/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.viatra2.core.EDeleteSemantics;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.IUndoManager;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteContainment;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectMoveTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetName;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationFrom;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetValue;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetViewInfo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectUserMark;
import org.eclipse.viatra2.core.simple.SimpleEntity;
import org.eclipse.viatra2.core.simple.SimpleModelElement;
import org.eclipse.viatra2.core.simple.SimpleModelManager;
import org.eclipse.viatra2.core.simple.SimpleRelation;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectAtomicStepReady;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUserMark;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.errors.VPMCoreNullParameterException;
import org.eclipse.viatra2.errors.VPMCoreRuntimeException;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleUndoManager
implements IUndoManager,
ICoreNotificationListener {
    IModelSpace modelSpace;
    SimpleModelManager mManager;
    Logger logger;
    private Stack<ICoreNotificationObject> undoStack = new Stack();
    boolean underUndo = false;
    boolean checkConsistencyOn = false;

    @Override
    public void init(Logger l, IModelSpace m) throws VPMRuntimeException {
        this.logger = l;
        this.modelSpace = m;
        this.mManager = (SimpleModelManager)this.modelSpace.getModelManager();
    }

    @Override
    public void nextUndoBlock(String name) {
        NotificationObjectUserMark no = new NotificationObjectUserMark(name);
        this.undoStack.push(no);
    }

    @Override
    public boolean canUndo() {
        return !this.undoStack.empty();
    }

    @Override
    public void flushUndoBuffer() {
        this.undoStack = new Stack();
    }

    @Override
    public void undo() {
        this.underUndo = true;
        boolean empty = false;
        boolean wasChange = false;
        ICoreNotificationObject note = null;
        do {
            if (this.undoStack.isEmpty()) {
                empty = true;
                break;
            }
            note = this.undoStack.pop();
            try {
                wasChange = this.undoStep(note) || wasChange;
            }
            catch (VPMCoreException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
        } while (note.getActionType() != "atomic step ready" || !wasChange);
        if (!empty) {
            this.undoStack.push(note);
        }
        this.underUndo = false;
    }

    @Override
    public void undo(String markName) {
        this.underUndo = true;
        boolean wasChange = false;
        boolean toLeave = false;
        ICoreNotificationObject note = null;
        while (!this.undoStack.isEmpty()) {
            ICoreNotificationObjectUserMark _note;
            String name;
            note = this.undoStack.pop();
            try {
                wasChange = this.undoStep(note) || wasChange;
            }
            catch (VPMCoreException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            if (note.getActionType().equals("atomic step ready")) {
                wasChange = false;
            }
            if (note.getActionType().equals("user mark") && (name = (_note = (ICoreNotificationObjectUserMark)((Object)note)).getMarkName()).equals(markName)) {
                toLeave = true;
            }
            if (!toLeave || wasChange) continue;
        }
        this.undoStack.push(new NotificationObjectAtomicStepReady());
        this.underUndo = false;
    }

    @Override
    public void undo(String markName, int n) {
        int i = 0;
        while (i < n) {
            this.undo(markName);
            ++i;
        }
    }

    @Override
    public void undo(int n) {
        int i = 0;
        while (i < n) {
            this.undo();
            ++i;
        }
    }

    private boolean undoStep(ICoreNotificationObject note) throws VPMCoreException {
        String action = note.getActionType();
        if (action.equals("atomic step ready")) {
            return false;
        }
        if (action.equals("create entity")) {
            ICoreNotificationObjectCreateEntity _note = (ICoreNotificationObjectCreateEntity)note;
            IEntity ent = _note.getCreated();
            try {
                this.mManager.deleteEntity(ent, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
            }
            catch (Exception e) {
                throw new VPMCoreRuntimeException("undo step failed" + e.toString() + e.getStackTrace());
            }
            return true;
        }
        if (action.equals("delete entity")) {
            ICoreNotificationObjectDeleteEntity _note = (ICoreNotificationObjectDeleteEntity)note;
            IEntity ent = _note.getDeleted();
            IEntity parent = _note.getParent();
            this.mManager.undoCreateEntity((SimpleEntity)ent, (SimpleEntity)parent);
            return true;
        }
        if (action.equals("create relation")) {
            ICoreNotificationObjectCreateRelation _note = (ICoreNotificationObjectCreateRelation)note;
            IRelation rel = _note.getNewRelation();
            try {
                this.mManager.deleteRelation(rel, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
            }
            catch (Exception e) {
                throw new VPMCoreRuntimeException("undo step failed" + e.toString() + e.getStackTrace());
            }
            return true;
        }
        if (action.equals("delete relation")) {
            ICoreNotificationObjectDeleteRelation _note = (ICoreNotificationObjectDeleteRelation)note;
            this.mManager.undoCreateRelation((SimpleRelation)_note.getDeleted(), (SimpleModelElement)_note.getFrom(), (SimpleModelElement)_note.getTo());
            return true;
        }
        if (action.equals("create instanceof")) {
            ICoreNotificationObjectCreateInstanceOf _note = (ICoreNotificationObjectCreateInstanceOf)note;
            SimpleModelElement sup = (SimpleModelElement)_note.getType();
            SimpleModelElement sub = (SimpleModelElement)_note.getInstance();
            try {
                this.mManager.deleteInstanceOfEditor(sup, sub);
            }
            catch (VPMCoreNullParameterException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("delete instanceof")) {
            ICoreNotificationObjectDeleteInstanceOf _note = (ICoreNotificationObjectDeleteInstanceOf)note;
            SimpleModelElement sup = (SimpleModelElement)_note.getType();
            SimpleModelElement sub = (SimpleModelElement)_note.getInstance();
            try {
                this.mManager.newInstanceOfEditor(sup, sub);
            }
            catch (Exception e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("create supertypeof")) {
            ICoreNotificationObjectCreateSupertypeOf _note = (ICoreNotificationObjectCreateSupertypeOf)note;
            SimpleModelElement sup = (SimpleModelElement)_note.getSuper();
            SimpleModelElement sub = (SimpleModelElement)_note.getSub();
            try {
                this.mManager.deleteSupertypeOfEditor(sup, sub);
            }
            catch (VPMCoreNullParameterException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("delete supertypeof")) {
            ICoreNotificationObjectDeleteSupertypeOf _note = (ICoreNotificationObjectDeleteSupertypeOf)note;
            SimpleModelElement sup = (SimpleModelElement)_note.getSuper();
            SimpleModelElement sub = (SimpleModelElement)_note.getSub();
            try {
                this.mManager.newSupertypeOfEditor(sup, sub);
            }
            catch (VPMCoreException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("delete containment")) {
            ICoreNotificationObjectDeleteContainment _note = (ICoreNotificationObjectDeleteContainment)note;
            SimpleEntity container = (SimpleEntity)_note.getParent();
            SimpleEntity child = (SimpleEntity)_note.getChild();
            try {
                this.mManager.undoCreateContainment(container, child);
            }
            catch (VPMCoreNullParameterException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("set value")) {
            ICoreNotificationObjectSetValue _note = (ICoreNotificationObjectSetValue)note;
            SimpleEntity ent = (SimpleEntity)_note.getEntity();
            String oldValue = _note.getOldValue();
            try {
                this.mManager.setValue(ent, oldValue);
            }
            catch (VPMCoreNullParameterException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("set name")) {
            ICoreNotificationObjectSetName _note = (ICoreNotificationObjectSetName)note;
            SimpleModelElement elem = (SimpleModelElement)_note.getElement();
            String oldName = _note.getOldName();
            try {
                this.mManager.setName(elem, oldName);
            }
            catch (VPMCoreNullParameterException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("move element to")) {
            ICoreNotificationObjectMoveTo _note = (ICoreNotificationObjectMoveTo)note;
            SimpleEntity elem = (SimpleEntity)_note.getElement();
            SimpleEntity from = (SimpleEntity)_note.getOldContainer();
            try {
                this.mManager.moveEntityTo(elem, from);
            }
            catch (VPMCoreNullParameterException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("set relation from")) {
            ICoreNotificationObjectSetRelationFrom _note = (ICoreNotificationObjectSetRelationFrom)note;
            SimpleRelation rel = (SimpleRelation)_note.getRelation();
            SimpleModelElement oldFrom = (SimpleModelElement)_note.getOldFrom();
            try {
                this.mManager.setRelationFrom(rel, oldFrom);
            }
            catch (VPMCoreNullParameterException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("set relation to")) {
            ICoreNotificationObjectSetRelationTo _note = (ICoreNotificationObjectSetRelationTo)note;
            SimpleRelation rel = (SimpleRelation)_note.getRelation();
            SimpleModelElement oldTo = (SimpleModelElement)_note.getOldTo();
            try {
                this.mManager.setRelationTo(rel, oldTo);
            }
            catch (VPMCoreNullParameterException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            return true;
        }
        if (action.equals("set view info")) {
            this.undoSetViewInfo((ICoreNotificationObjectSetViewInfo)note);
            return true;
        }
        if (action.equals("user mark")) {
            return false;
        }
        return false;
    }

    void undoSetViewInfo(ICoreNotificationObjectSetViewInfo note) {
        IModelElement me = note.getElement();
        String oldViewInfo = note.getOldViewInfo();
        try {
            this.mManager.setViewInfo(me, oldViewInfo);
        }
        catch (VPMCoreException e) {
            this.logger.fatal("Error performing undo; message: " + e.getMessage());
        }
    }

    @Override
    public List<String> getUndoableList() {
        ArrayList<String> undoList = new ArrayList<String>();
        for (ICoreNotificationObject note : this.undoStack) {
            undoList.add(note.toString());
        }
        return undoList;
    }

    @Override
    public void actionPerformed(ICoreNotificationObject notification) {
        String type = notification.getActionType();
        if (type.equals("begin subtransaction") || type.equals("end subtransaction") || type.equals("begin transaction") || type.equals("end transaction") || type.equals("begin undoable transaction")) {
            return;
        }
        if (!this.underUndo) {
            this.undoStack.add(notification);
        }
    }

    @Override
    public int getListenerCategory() {
        return 0;
    }

    @Override
    public List<String> getUndoList(int n) {
        int count = 0;
        ArrayList<String> ret = new ArrayList<String>();
        int last = this.undoStack.size();
        while (count < n) {
            ICoreNotificationObject note;
            if ((note = (ICoreNotificationObject)this.undoStack.get(--last)).getActionType().equals("user mark")) {
                ret.add(((ICoreNotificationObjectUserMark)((Object)note)).getMarkName());
                ++count;
            }
            if (last == 0) break;
        }
        return ret;
    }
}

