/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.errors.info;

import org.eclipse.viatra2.errors.info.Location;

public class ErrorInformation {
    private String message;
    private Location location;
    private ErrorSeverity errorSeverity;
    private ErrorKind errorKind;
    private static final String defaultMarkerId = "org.eclipse.viatra2.loaders.vtclparsermarker";
    private String markerId = "org.eclipse.viatra2.loaders.vtclparsermarker";

    public ErrorInformation(String m, ErrorKind errorKind) {
        this(m, defaultMarkerId, errorKind, new Location(0, 0, 0, 0), ErrorSeverity.ERROR);
    }

    public ErrorInformation(String m, String markerId, ErrorKind errorKind) {
        this(m, markerId, new Location(0, 0, 0, 0), ErrorSeverity.ERROR);
    }

    public ErrorInformation(String m, ErrorKind errorKind, int bl, int el, int bc, int ec) {
        this(m, defaultMarkerId, errorKind, new Location(bl, el, bc, ec), ErrorSeverity.ERROR);
    }

    public ErrorInformation(String m, String markerId, ErrorKind errorKind, int bl, int el, int bc, int ec) {
        this(m, markerId, errorKind, new Location(bl, el, bc, ec), ErrorSeverity.ERROR);
    }

    public ErrorInformation(String m, ErrorKind errorKind, Location loc) {
        this(m, defaultMarkerId, errorKind, loc, ErrorSeverity.ERROR);
    }

    public ErrorInformation(String m, ErrorKind errorKind, Location loc, ErrorSeverity level) {
        this(m, defaultMarkerId, errorKind, loc, level);
    }

    public ErrorInformation(String m, String markerId, ErrorKind errorKind, Location loc, ErrorSeverity level) {
        this.message = m;
        this.location = loc;
        this.errorSeverity = level;
        this.errorKind = errorKind;
    }

    public ErrorInformation(String m, String markerId, Location loc, ErrorSeverity level) {
        this.message = m;
        this.location = loc;
        this.errorSeverity = level;
        this.errorKind = ErrorKind.PARSE_ERROR;
        this.markerId = markerId;
    }

    public ErrorKind getErrorKind() {
        return this.errorKind;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageWithLocation() {
        String locStr = new String(String.valueOf(String.valueOf(this.location.getBeginLine())) + ":" + String.valueOf(this.location.getBeginColumn()) + ":" + String.valueOf(this.location.getEndLine()) + ":" + String.valueOf(this.location.getEndColumn()));
        return new String(String.valueOf(locStr) + " : " + this.message);
    }

    public ErrorSeverity getErrorSeverity() {
        return this.errorSeverity;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getMarkerId() {
        return this.markerId;
    }

    public void bind(String[] context) {
        if (context.length >= 1) {
            this.message = this.message.replace("{1}", context[0]);
        }
        if (context.length >= 2) {
            this.message = this.message.replace("{2}", context[1]);
        }
        if (context.length >= 3) {
            this.message = this.message.replace("{3}", context[2]);
        }
        if (context.length >= 4) {
            this.message = this.message.replace("{4}", context[3]);
        }
        if (context.length >= 5) {
            this.message = this.message.replace("{5}", context[4]);
        }
        if (this.message.contains("{ALL}")) {
            String allContext = new String();
            int i = 0;
            while (i < context.length) {
                allContext = String.valueOf(allContext) + context[i] + (i < context.length - 1 ? ", " : "");
                ++i;
            }
            this.message = this.message.replace("{ALL}", allContext);
        }
    }

    public boolean isEquivalent(ErrorInformation ei) {
        boolean crit5;
        boolean crit1 = this.errorKind.equals((Object)ei.errorKind);
        boolean crit2 = this.errorSeverity.equals((Object)ei.errorSeverity);
        boolean crit3 = this.location.getBeginLine() == ei.location.getBeginLine();
        boolean crit4 = this.message.toLowerCase().indexOf(ei.message.toLowerCase()) > -1;
        boolean bl = crit5 = ei.message.toLowerCase().indexOf(this.message.toLowerCase()) > -1;
        return crit1 && crit2 && crit3 && (crit4 || crit5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorKind {
        PARSE_ERROR,
        VALIDATION_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorSeverity {
        INFO,
        WARNING,
        ERROR;

    }
}

