/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.exports;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;

public class VTMLExporterSimple {
    PrintWriter out;
    IModelElement root;
    List<IRelation> relations = new ArrayList<IRelation>();
    List<Instance> instances = new ArrayList<Instance>();
    List<Instance> suptypes = new ArrayList<Instance>();

    public static void exportToVTML(String fileName, IModelSpace modelSpace, IModelElement branch) {
        try {
            FileWriter fw = new FileWriter(fileName);
            PrintWriter pw = new PrintWriter(fw);
            VTMLExporterSimple.exportToVTML(pw, modelSpace, branch);
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportToVTML(PrintWriter out, IModelSpace modelSpace, IModelElement branch) {
        VTMLExporterSimple exp = new VTMLExporterSimple();
        exp.export(out, modelSpace, branch);
    }

    private void export(PrintWriter out, IModelSpace modelSpace, IModelElement branch) {
        Instance supT;
        this.out = out;
        this.root = branch;
        this.exportElement(branch, "");
        int i = 0;
        while (i < this.relations.size()) {
            IRelation rel = this.relations.get(i);
            String typeString = "relation";
            out.println(String.valueOf(typeString) + "(" + this.makeVTMLName(rel) + "," + this.makeVTMLName(rel.getFrom()) + "," + this.makeVTMLName(rel.getTo()) + ");");
            ++i;
        }
        i = 0;
        while (i < this.suptypes.size()) {
            supT = this.suptypes.get(i);
            out.println("supertypeOf(" + this.makeVTMLName(supT.getType()) + "," + this.makeVTMLName(supT.getInst()) + ");");
            ++i;
        }
        i = 0;
        while (i < this.instances.size()) {
            supT = this.instances.get(i);
            out.println("instanceOf(" + this.makeVTMLName(supT.getInst()) + "," + this.makeVTMLName(supT.getType()) + ");");
            ++i;
        }
    }

    private void exportElement(IModelElement me, String prefix) {
        if (this.isEntity(me)) {
            IEntity ent = this.toEntity(me);
            this.out.print(String.valueOf(prefix) + "entity(" + this.makeVTMLName(me) + ")");
            this.out.print("->\"" + ent.getValue() + "\"");
            Collection<IModelElement> col = ent.getElementsInNamespace();
            if (col.size() == 0) {
                this.out.println(";");
            } else {
                this.out.println("\n" + prefix + "{");
                String newPrefix = String.valueOf(prefix) + "\t";
                for (IModelElement child : col) {
                    this.exportElement(child, newPrefix);
                }
                this.out.println(String.valueOf(prefix) + "}");
            }
        }
        if (this.isRelation(me)) {
            IRelation rel = this.toRelation(me);
            this.relations.add(rel);
            Collection<IRelation> subs = rel.getRelationsFrom();
            for (IRelation srel : subs) {
                this.exportElement(srel, prefix);
            }
        }
        for (IModelElement type : me.getTypes()) {
            this.instances.add(new Instance(type, me));
        }
        for (IModelElement inst : me.getInstances()) {
            if (!this.isOutsider(inst)) continue;
            this.instances.add(new Instance(me, inst));
        }
        for (IModelElement sup : me.getSupertypes()) {
            this.suptypes.add(new Instance(sup, me));
        }
        for (IModelElement sub : me.getSubtypes()) {
            if (!this.isOutsider(sub)) continue;
            this.suptypes.add(new Instance(me, sub));
        }
    }

    private boolean isOutsider(IModelElement me) {
        if (me.getFullyQualifiedName().equals(this.root)) {
            return false;
        }
        return !me.getFullyQualifiedName().startsWith(this.root + ".");
    }

    public String makeVTMLName(IModelElement me) {
        String fqn = me.getFullyQualifiedName();
        StringBuffer ret = new StringBuffer();
        StringTokenizer strtok = new StringTokenizer(fqn, ".");
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            ret.append("'" + token + "'" + ".");
        }
        ret.setLength(ret.length() - 1);
        return ret.toString();
    }

    private boolean isEntity(IModelElement me) {
        return me instanceof IEntity;
    }

    private IEntity toEntity(IModelElement me) {
        return (IEntity)me;
    }

    private IRelation toRelation(IModelElement me) {
        return (IRelation)me;
    }

    private boolean isRelation(IModelElement me) {
        return me instanceof IRelation;
    }

    class Instance {
        IModelElement type;
        IModelElement inst;

        Instance(IModelElement type, IModelElement inst) {
            this.type = type;
            this.inst = inst;
        }

        IModelElement getType() {
            return this.type;
        }

        IModelElement getInst() {
            return this.inst;
        }
    }
}

