/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.framework;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.viatra2.ViatraPlugin;
import org.eclipse.viatra2.codegen.CodeOutputPlugin;
import org.eclipse.viatra2.codegen.CodeOutputPluginFactory;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.exports.VPMExporter;
import org.eclipse.viatra2.framework.ExtensionProvider;
import org.eclipse.viatra2.framework.FrameworkException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkGlobalListener;
import org.eclipse.viatra2.framework.IFrameworkService;
import org.eclipse.viatra2.framework.IFrameworkServiceFactory;
import org.eclipse.viatra2.framework.IMachineSetChangedListener;
import org.eclipse.viatra2.framework.MultiCodeFormatter;
import org.eclipse.viatra2.framework.MultiLogger;
import org.eclipse.viatra2.framework.properties.IViatraPropertyProvider;
import org.eclipse.viatra2.framework.properties.VPMProperties;
import org.eclipse.viatra2.imports.IVPMImporter;
import org.eclipse.viatra2.imports.NativeImporter;
import org.eclipse.viatra2.imports.NativeImporterFactory;
import org.eclipse.viatra2.imports.VPMImporterSax;
import org.eclipse.viatra2.interpreters.IProgressReport;
import org.eclipse.viatra2.interpreters.ModelInterpreter;
import org.eclipse.viatra2.interpreters.ModelInterpreterFactory;
import org.eclipse.viatra2.loaders.Loader;
import org.eclipse.viatra2.loaders.LoaderFactory;
import org.eclipse.viatra2.logger.Logger;
import org.eclipse.viatra2.logger.LoggerFactory;
import org.eclipse.viatra2.merger.Merger;
import org.eclipse.viatra2.merger.VPMMergeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.INativeFunctionManager;
import org.eclipse.viatra2.natives.NativeFunctionManager;
import org.eclipse.viatra2.tags.ITagManager;
import org.eclipse.viatra2.tags.impl.TagManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Framework
implements IFramework {
    public static final String parserManagerServiceId = "org.eclipse.viatra2.loaders.vtcl_lpgparser.loader.VTCLParserManager";
    MultiCodeFormatter codeout;
    String modelmerger = "";
    String id = "";
    private String currentfilename = "";
    NativeFunctionManager nativeFunctionManager;
    HashMap<String, NativeImporterFactory> imports = new HashMap();
    HashMap<String, LoaderFactory> loaders = new HashMap();
    IModelSpace topmodel;
    MultiLogger logger = new MultiLogger();
    HashSet<IMachineSetChangedListener> machine_set_listeners = new HashSet();
    private final HashMap<String, Object> machine_models = new HashMap();
    private final Map<String, IFrameworkService> service_providers = new HashMap<String, IFrameworkService>();
    private final Map<String, IFrameworkServiceFactory> service_factories = new HashMap<String, IFrameworkServiceFactory>();
    private TagManager tagManager;
    private VPMProperties props;
    boolean isInit = false;
    ExtensionProvider exProvider;
    HashSet<IFrameworkGlobalListener> globalListeners = new HashSet();

    @Override
    public ITagManager getTagManager() {
        return this.tagManager;
    }

    @Override
    public String getCurrentFilename() {
        return this.currentfilename;
    }

    @Override
    public void setCurrentFileName(String fName) {
        this.currentfilename = fName;
        for (IFrameworkGlobalListener l : this.globalListeners) {
            l.frameworkNameChanged();
        }
    }

    public void dispose() {
        this.unregisterFrameworkService(parserManagerServiceId);
    }

    @Override
    public CodeOutputPlugin getCodeOutput() {
        return this.codeout;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    IModelSpace getNewModelSpace() throws FrameworkException {
        IModelSpace ms = this.exProvider.getEmptyModelspace(this.props);
        try {
            ms.init(this);
        }
        catch (Exception e) {
            this.logger.fatal("Cannot init modelspace");
            throw new FrameworkException("Exception initialising framework: cannot init modelspace class", e);
        }
        return ms;
    }

    public ModelInterpreterFactory getInterpreterFactory(Object entrypoint) throws FrameworkException {
        ModelInterpreterFactory[] is;
        ModelInterpreterFactory[] modelInterpreterFactoryArray = is = this.exProvider.getInterpreters();
        int n = is.length;
        int n2 = 0;
        while (n2 < n) {
            ModelInterpreterFactory iF = modelInterpreterFactoryArray[n2];
            String[] types = iF.getInterpretedClasses();
            if (types != null) {
                int i = 0;
                while (i < types.length) {
                    if (entrypoint.getClass().getCanonicalName().equals(types[i].trim())) {
                        iF.getInterpreter();
                        return iF;
                    }
                    ++i;
                }
            } else {
                ModelInterpreter i = iF.getInterpreter();
                if (i != null && i.isRunnable(entrypoint, this)) {
                    return iF;
                }
            }
            ++n2;
        }
        return null;
    }

    public void init(String initialModelFileName, String id, ExtensionProvider exProvider) throws FrameworkException {
        try {
            this.init(new FileInputStream(initialModelFileName), id, exProvider, initialModelFileName);
        }
        catch (FileNotFoundException e) {
            throw new FrameworkException("init failed", e);
        }
    }

    public void init(InputStream initialModelFile, String id, ExtensionProvider exProvider, String name) throws FrameworkException {
        LoaderFactory[] programloaders;
        NativeImporterFactory[] natives;
        CodeOutputPluginFactory[] allCodeOuts;
        String initialModelFileName;
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.id = id;
        this.currentfilename = initialModelFileName = name;
        this.exProvider = exProvider;
        Logger defaultLogger = exProvider.getDefaultLogger();
        if (defaultLogger != null) {
            this.logger.addListener(defaultLogger);
        }
        this.props = exProvider.getDefaultProperties();
        LoggerFactory[] logs = exProvider.getAvailableLoggers();
        LoggerFactory[] loggerFactoryArray = logs;
        int n = logs.length;
        int n2 = 0;
        while (n2 < n) {
            LoggerFactory fact = loggerFactoryArray[n2];
            Logger l = fact.getLogger();
            this.logger.addListener(l);
            ++n2;
        }
        if (this.props.isRuntimePropertySet("Logging", "Log level")) {
            this.logger.setLevel(Integer.valueOf(this.props.getRuntimeProperty("Logging", "Log level")));
        } else {
            this.logger.setLevel(3);
        }
        this.logger.debug("Logging session started");
        this.topmodel = this.getNewModelSpace();
        if (initialModelFile != null) {
            try {
                this.getImporter().process(initialModelFile, this.topmodel, this.props);
            }
            catch (Exception e) {
                this.logger.message(1, "Modelspace initialization failed.", e);
                throw new FrameworkException("Exception initialising framework", e);
            }
        }
        if (ViatraPlugin.getDefault().getPreferenceStore().contains("org.eclipse.viatra2.gui.preferences.DisableVPMLOverride") && ViatraPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.viatra2.gui.preferences.DisableVPMLOverride")) {
            for (IViatraPropertyProvider prov : ViatraPlugin.getDefault().getPropertyProviders()) {
                for (String prop_id : prov.getAllPropertyIds()) {
                    this.props.setRuntimeProperty(prov.getProviderID(), prop_id, ViatraPlugin.getDefault().getPreferenceStore().getString(String.valueOf(prov.getProviderID()) + "::" + prop_id));
                }
            }
        }
        if (this.props.isRuntimePropertySet("Logging", "Log level")) {
            this.logger.setLevel(Integer.valueOf(this.props.getRuntimeProperty("Logging", "Log level")));
        }
        this.tagManager = new TagManager();
        this.tagManager.init(this);
        this.codeout = new MultiCodeFormatter();
        this.codeout.init(this);
        CodeOutputPluginFactory[] codeOutputPluginFactoryArray = allCodeOuts = exProvider.getCodeOutputPlugins();
        int n3 = allCodeOuts.length;
        int prop_id = 0;
        while (prop_id < n3) {
            CodeOutputPluginFactory fact = codeOutputPluginFactoryArray[prop_id];
            CodeOutputPlugin pl = fact.createCodeoutPlugin(this);
            if (pl != null) {
                pl.init(this);
                this.codeout.addListener(pl);
            }
            ++prop_id;
        }
        NativeImporterFactory[] nativeImporterFactoryArray = natives = exProvider.getNativeImporters(this.props);
        int n4 = natives.length;
        n3 = 0;
        while (n3 < n4) {
            NativeImporterFactory factory = nativeImporterFactoryArray[n3];
            this.addNativeImporterFactory(factory);
            ++n3;
        }
        LoaderFactory[] loaderFactoryArray = programloaders = exProvider.getLoaders(this.props);
        int n5 = programloaders.length;
        n4 = 0;
        while (n4 < n5) {
            LoaderFactory factory = loaderFactoryArray[n4];
            this.addLoaderFactory(factory);
            ++n4;
        }
        ASMNativeFunction[] natFuns = exProvider.getNativeFunctions();
        this.nativeFunctionManager = new NativeFunctionManager();
        this.nativeFunctionManager.addAllFunction(natFuns);
        this.initializeServiceFactory(parserManagerServiceId);
        this.registerFrameworkService(parserManagerServiceId);
        this.service_providers.get(parserManagerServiceId).init(this);
    }

    @Override
    public IModelSpace getTopmodel() {
        return this.topmodel;
    }

    private void addNativeImporterFactory(NativeImporterFactory fact) {
        int f = 1;
        NativeImporterFactory s = fact;
        String preferredImporterId = s.getId();
        if (preferredImporterId == null) {
            preferredImporterId = "noname";
        }
        String importerId = preferredImporterId;
        while (this.imports.get(importerId) != null) {
            importerId = String.valueOf(preferredImporterId) + f;
            ++f;
        }
        this.imports.put(importerId, s);
        this.logger.info("Added new importer plugin '" + importerId + "' (" + s.getImporterName() + ")");
    }

    private void addLoaderFactory(LoaderFactory fact) {
        int f = 1;
        LoaderFactory s = fact;
        String preferredImporterId = s.getId();
        if (preferredImporterId == null) {
            preferredImporterId = "noname";
        }
        String importerId = preferredImporterId;
        while (this.loaders.get(importerId) != null) {
            importerId = String.valueOf(preferredImporterId) + f;
            ++f;
        }
        this.loaders.put(importerId, s);
        this.logger.info("Added new loader plugin '" + importerId + "' (" + s.getLoaderName() + ")");
    }

    @Override
    public Map<String, NativeImporterFactory> getNativeImporters() {
        return this.imports;
    }

    @Override
    public Map<String, LoaderFactory> getLoaders() {
        return this.loaders;
    }

    @Override
    public void addMachine(String fqn, Object machine) throws FrameworkException {
        this.machine_models.put(fqn, machine);
        for (IMachineSetChangedListener l : this.machine_set_listeners) {
            l.machineAdded(machine);
        }
    }

    @Override
    public void removeMachine(String fqn) throws FrameworkException {
        Object machine = this.machine_models.get(fqn);
        this.machine_models.remove(fqn);
        for (IMachineSetChangedListener l : this.machine_set_listeners) {
            l.machineRemoved(machine);
        }
    }

    @Override
    public void loadMachine(String fileName, String loaderName) throws FrameworkException {
        Loader l;
        LoaderFactory lf = this.loaders.get(loaderName);
        if (lf == null) {
            throw new FrameworkException("Loader for type " + loaderName + " is not defined.");
        }
        try {
            l = lf.getLoaderInstance();
        }
        catch (Exception e) {
            this.logger.message(1, "Error loading loader: " + loaderName, e);
            throw new FrameworkException("Error loading loader: " + loaderName, e);
        }
        if (l == null) {
            throw new FrameworkException("Loader for type " + loaderName + " is not defined.");
        }
        try {
            l.processFile(fileName, this);
        }
        catch (VPMRuntimeException e) {
            throw new FrameworkException("Loader ended with error", e);
        }
    }

    @Override
    public void loadMachine(InputStream stream, String loaderName) throws FrameworkException {
        Loader l;
        LoaderFactory lf = this.loaders.get(loaderName);
        if (lf == null) {
            throw new FrameworkException("Loader for type " + loaderName + " is not defined.");
        }
        try {
            l = lf.getLoaderInstance();
        }
        catch (Exception e) {
            this.logger.message(1, "Error loading loader: " + loaderName, e);
            throw new FrameworkException("Error loading loader: " + loaderName, e);
        }
        if (l == null) {
            throw new FrameworkException("Loader for type " + loaderName + " is not defined.");
        }
        try {
            l.process(stream, this);
        }
        catch (VPMRuntimeException e) {
            throw new FrameworkException("Loader ended with error", e);
        }
    }

    @Override
    public void nativeImport(String fileName, String importerName) throws FrameworkException {
        NativeImporter cla;
        NativeImporterFactory claf = this.imports.get(importerName);
        if (claf == null) {
            throw new FrameworkException("Native importer for type " + importerName + " is not defined.");
        }
        try {
            cla = claf.getImporterInstance();
        }
        catch (Exception e) {
            this.logger.message(1, "Error loading importer: " + importerName, e);
            throw new FrameworkException("Error loading importer: " + importerName, e);
        }
        if (cla == null) {
            throw new FrameworkException("Native importer for type " + importerName + " is not defined.");
        }
        try {
            try {
                this.topmodel.getTransactionManager().beginTransaction(Boolean.TRUE);
                cla.processFile(fileName, this);
            }
            catch (VPMRuntimeException ex) {
                throw new FrameworkException("Native import ended with error", ex);
            }
            catch (Exception ex2) {
                throw new FrameworkException("Native import ended with error", ex2);
            }
        }
        finally {
            this.topmodel.getTransactionManager().commitTransaction();
        }
    }

    @Override
    public void nativeImport(InputStream stream, String importerName) throws FrameworkException {
        NativeImporter cla;
        NativeImporterFactory claf = this.imports.get(importerName);
        if (claf == null) {
            throw new FrameworkException("Native importer for type " + importerName + " is not defined.");
        }
        try {
            cla = claf.getImporterInstance();
        }
        catch (Exception e) {
            this.logger.message(1, "Error loading importer: " + importerName, e);
            throw new FrameworkException("Error loading importer: " + importerName, e);
        }
        if (cla == null) {
            throw new FrameworkException("Native importer for type " + importerName + " is not defined.");
        }
        try {
            try {
                this.topmodel.getTransactionManager().beginTransaction(Boolean.TRUE);
                cla.process(stream, this);
            }
            catch (VPMRuntimeException ex) {
                throw new FrameworkException("Native import ended with error", ex);
            }
            catch (Exception ex2) {
                throw new FrameworkException("Native import ended with error", ex2);
            }
        }
        finally {
            this.topmodel.getTransactionManager().commitTransaction();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    private IVPMImporter getImporter() {
        return new VPMImporterSax();
    }

    public String getImporterName(String tt) {
        NativeImporterFactory cla = this.imports.get(tt);
        if (cla == null) {
            this.logger.error("Native importer for type " + tt + " is not defined.");
            return null;
        }
        try {
            return cla.getImporterName();
        }
        catch (Exception ex2) {
            this.logger.error("Unable to load native importer class: " + ex2.getMessage());
            return null;
        }
    }

    public String getLoaderName(String tt) {
        LoaderFactory cla = this.loaders.get(tt);
        if (cla == null) {
            this.logger.error("Loader for type " + tt + " is not defined.");
            return null;
        }
        try {
            return cla.getLoaderName();
        }
        catch (Exception ex2) {
            this.logger.error("Unable to load loader class: " + ex2.getMessage());
            return null;
        }
    }

    @Override
    public void saveFile(String s) throws FrameworkException, IOException {
        new VPMExporter().export((IFramework)this, s);
        this.currentfilename = s;
    }

    @Override
    public Collection<Object> getMachines() {
        return this.machine_models.values();
    }

    @Override
    public Object getMachineByFQN(String fqn) {
        return this.machine_models.get(fqn);
    }

    @Override
    public boolean isRunnable(Object machine) throws FrameworkException {
        return this.getInterpreterFactory(machine) != null;
    }

    @Override
    public void runEntrypoint(Object entrypoint, Map<String, Object> params, IProgressReport pr) throws VPMRuntimeException {
        if (params == null) {
            params = new TreeMap<String, Object>();
        }
        ModelInterpreter interpreter = null;
        try {
            interpreter = this.getInterpreterFactory(entrypoint).getInterpreter();
        }
        catch (Exception e) {
            this.logger.message(0, "couldn't load Model Interpreter class. ", e);
            throw new VPMRuntimeException("could not run entrypoint");
        }
        try {
            if (interpreter != null) {
                interpreter.run(this, entrypoint, params, pr);
                this.logger.info("Entity successfully interpreted.");
            }
        }
        catch (RuntimeException e) {
            String exMessage = e.getMessage();
            String message = "Error happened while running interpreter, please report to VIATRA2 developers" + (exMessage == null ? ". " : ": " + exMessage + " ");
            this.logger.message(1, message, e);
            throw new VPMRuntimeException(message, e);
        }
    }

    @Override
    public String[] getEntrypointParameters(Object machine) throws FrameworkException {
        ModelInterpreter interpreter = null;
        try {
            interpreter = this.getInterpreterFactory(machine).getInterpreter();
        }
        catch (Exception e) {
            this.logger.message(0, "couldn't load Model Interpreter class. ", e);
            throw new FrameworkException("could not load model interpreter");
        }
        try {
            if (interpreter != null) {
                return interpreter.getParameters(this, machine);
            }
        }
        catch (VPMRuntimeException e) {
            this.logger.error(e.getMessage());
            throw new FrameworkException(e.getMessage(), e);
        }
        catch (Exception e) {
            try {
                FileOutputStream fo = new FileOutputStream("log.out");
                PrintWriter pw = new PrintWriter(fo);
                e.printStackTrace(pw);
                pw.flush();
                fo.close();
            }
            catch (Exception exception) {}
            this.logger.error(String.valueOf(e.getMessage()) + " error log created in file log.out. Please report");
            throw new FrameworkException("could not run initialize model interpreter");
        }
        return new String[0];
    }

    public void merge(String fileName) throws VPMMergeException, FrameworkException {
        IModelSpace toMerge = this.getNewModelSpace();
        try {
            this.getImporter().process(fileName, toMerge, new VPMProperties());
        }
        catch (VPMRuntimeException e) {
            throw new FrameworkException("Opening file failed", e);
        }
        this.merge(toMerge);
    }

    @Override
    public void mergeStream(InputStream stream) throws FrameworkException, IOException {
        IModelSpace toMerge = this.getNewModelSpace();
        try {
            this.getImporter().process(stream, toMerge, new VPMProperties());
        }
        catch (VPMRuntimeException e) {
            throw new FrameworkException("Opening file failed", e);
        }
        try {
            this.merge(toMerge);
        }
        catch (VPMMergeException mex) {
            throw new FrameworkException("error merging", mex);
        }
    }

    public void merge(IModelSpace modelSpace) throws VPMMergeException {
        Merger mg = new Merger();
        this.getTopmodel().getTransactionManager().beginTransaction(Boolean.TRUE);
        mg.merge(modelSpace, this.getTopmodel());
        this.getTopmodel().getTransactionManager().commitTransaction();
    }

    @Override
    public void addLoggerListener(Logger l) {
        this.logger.addListener(l);
    }

    @Override
    public Collection<Logger> getAllLoggerListeners() {
        return this.logger.getListeners();
    }

    @Override
    public void removeLoggerListener(Logger l) {
        this.logger.removeListener(l);
    }

    @Override
    public void addCodeOutListener(CodeOutputPlugin l) {
        this.codeout.addListener(l);
    }

    @Override
    public Collection<CodeOutputPlugin> getAllCodeOutListeners() {
        return this.codeout.getListeners();
    }

    @Override
    public void removeCodeOutListener(CodeOutputPlugin l) {
        this.codeout.removeListener(l);
    }

    @Override
    public Collection<CodeOutputPluginFactory> getAvailableCodeOutPlugins() {
        ArrayList<CodeOutputPluginFactory> ret = new ArrayList<CodeOutputPluginFactory>();
        try {
            CodeOutputPluginFactory[] codeOutputPluginFactoryArray = this.exProvider.getCodeOutputPlugins();
            int n = codeOutputPluginFactoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeOutputPluginFactory factory = codeOutputPluginFactoryArray[n2];
                ret.add(factory);
                ++n2;
            }
        }
        catch (FrameworkException frameworkException) {
            this.logger.fatal("Fatal error querying code output plugins");
        }
        return ret;
    }

    @Override
    public Collection<LoggerFactory> getAvailableLoggers() {
        ArrayList<LoggerFactory> ret = new ArrayList<LoggerFactory>();
        try {
            LoggerFactory[] loggerFactoryArray = this.exProvider.getAvailableLoggers();
            int n = loggerFactoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                LoggerFactory factory = loggerFactoryArray[n2];
                ret.add(factory);
                ++n2;
            }
        }
        catch (FrameworkException frameworkException) {
            this.logger.fatal("Fatal error querying code available loggers");
        }
        return ret;
    }

    @Override
    public Collection<ModelInterpreterFactory> getAvailableInterpreters() {
        ArrayList<ModelInterpreterFactory> ret = new ArrayList<ModelInterpreterFactory>();
        ModelInterpreterFactory[] modelInterpreterFactoryArray = this.exProvider.getInterpreters();
        int n = modelInterpreterFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelInterpreterFactory factory = modelInterpreterFactoryArray[n2];
            ret.add(factory);
            ++n2;
        }
        return ret;
    }

    @Override
    public INativeFunctionManager getNativeFunctionManager() {
        return this.nativeFunctionManager;
    }

    @Override
    public void mergeFile(String fileName) throws FrameworkException, IOException {
        try {
            this.merge(fileName);
        }
        catch (VPMMergeException mex) {
            throw new FrameworkException("error merging", mex);
        }
    }

    @Override
    public void saveFile(OutputStream os, String currentFileName) throws FrameworkException, IOException {
        new VPMExporter().export((IFramework)this, os);
        this.currentfilename = currentFileName;
    }

    @Override
    public VPMProperties getProperties() {
        return this.props;
    }

    @Override
    public Set<String> getNativeImportersForExtension(String ext) {
        HashSet<String> ret = new HashSet<String>();
        for (NativeImporterFactory f : this.imports.values()) {
            String[] exts = f.getFileExtensionList();
            int i = 0;
            while (i < exts.length) {
                if (exts[i].equalsIgnoreCase(ext)) {
                    ret.add(f.getId());
                }
                ++i;
            }
        }
        return ret;
    }

    @Override
    public Set<String> getLoadersForExtension(String ext) {
        HashSet<String> ret = new HashSet<String>();
        for (LoaderFactory f : this.loaders.values()) {
            String[] exts = f.getFileExtensionList();
            int i = 0;
            while (i < exts.length) {
                if (exts[i].equalsIgnoreCase(ext)) {
                    ret.add(f.getId());
                }
                ++i;
            }
        }
        return ret;
    }

    @Override
    public void addMachineSetListener(IMachineSetChangedListener l) {
        if (!this.machine_set_listeners.contains(l)) {
            this.machine_set_listeners.add(l);
        }
    }

    @Override
    public void removeMachineSetListener(IMachineSetChangedListener l) {
        this.machine_set_listeners.remove(l);
    }

    @Override
    public void addFrameworkGlobalListener(IFrameworkGlobalListener l) {
        this.globalListeners.add(l);
    }

    @Override
    public Collection<IFrameworkGlobalListener> getAllGlobalListeners() {
        return this.globalListeners;
    }

    @Override
    public void removeFrameworkGlobalListener(IFrameworkGlobalListener l) {
        this.globalListeners.remove(l);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ITagManager.class)) {
            return this.getTagManager();
        }
        if (adapter.equals(IModelSpace.class)) {
            return this.getTopmodel();
        }
        return null;
    }

    @Override
    public IFrameworkService getVTCLParserManager() {
        return this.service_providers.get(parserManagerServiceId);
    }

    @Override
    public void registerFrameworkService(String serviceName) throws FrameworkException {
        IFrameworkServiceFactory factory = this.service_factories.get(serviceName);
        if (factory == null) {
            throw new FrameworkException("Factory class cannot be found for service" + serviceName);
        }
        IFrameworkService service = factory.create();
        this.service_providers.put(serviceName, service);
    }

    @Override
    public void unregisterFrameworkService(String serviceName) {
        IFrameworkService service = this.service_providers.get(serviceName);
        if (service != null) {
            this.service_providers.remove(serviceName);
        }
    }

    protected void initializeServiceFactory(String serviceName) throws FrameworkException {
        if (this.service_factories.get(serviceName) == null) {
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.viatra2.core2.frameworkservice");
            boolean found = false;
            int i = 0;
            while (!found && i < configs.length) {
                IConfigurationElement config = configs[i];
                String currentServiceName = config.getAttribute("servicename");
                if (serviceName.equals(currentServiceName)) {
                    found = true;
                    try {
                        IFrameworkServiceFactory factory = (IFrameworkServiceFactory)config.createExecutableExtension("factoryclass");
                        this.service_factories.put(serviceName, factory);
                    }
                    catch (CoreException e) {
                        throw new FrameworkException("Framework service factory cannot be found", e);
                    }
                }
                ++i;
            }
        }
    }
}

