/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.framework;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.buffers.BufferStore;
import org.eclipse.viatra2.codegen.CodeOutputPlugin;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.properties.VPMProperties;
import org.eclipse.viatra2.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiCodeFormatter
implements CodeOutputPlugin {
    protected VPMProperties props;
    protected Logger logger;
    protected IFramework frame;
    List<CodeOutputPlugin> listeners = new ArrayList<CodeOutputPlugin>();

    @Override
    public void beginWork() {
        int i = 0;
        while (i < this.listeners.size()) {
            CodeOutputPlugin cp = this.listeners.get(i);
            cp.beginWork();
            ++i;
        }
    }

    @Override
    public void codeOut(String s) throws VPMRuntimeException {
        int i = 0;
        while (i < this.listeners.size()) {
            CodeOutputPlugin cp = this.listeners.get(i);
            cp.codeOut(s);
            ++i;
        }
    }

    @Override
    public void endWork() {
        int i = 0;
        while (i < this.listeners.size()) {
            CodeOutputPlugin cp = this.listeners.get(i);
            cp.endWork();
            ++i;
        }
        Set<Map.Entry<String, FileWriter>> fileBuffers = BufferStore.getAllFileBuffers(this.frame.getTopmodel());
        if (fileBuffers != null) {
            try {
                for (Map.Entry<String, FileWriter> buf : fileBuffers) {
                    buf.getValue().flush();
                    buf.getValue().close();
                }
            }
            catch (IOException e) {
                this.logger.fatal(e.getMessage());
            }
            BufferStore.removeFileBuffers(this.frame.getTopmodel());
        }
    }

    @Override
    public void init(IFramework fw) {
        this.frame = fw;
        this.props = fw.getProperties();
        this.logger = fw.getLogger();
    }

    public void addListener(CodeOutputPlugin listener) {
        this.listeners.add(listener);
        listener.init(this.frame);
    }

    public void removeListener(CodeOutputPlugin listener) {
        this.listeners.remove(listener);
    }

    public Collection<CodeOutputPlugin> getListeners() {
        return this.listeners;
    }
}

