/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.framework.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.viatra2.framework.properties.IViatraPropertyProvider;
import org.eclipse.viatra2.framework.properties.IViatraPropertyProvidersChangedListener;
import org.eclipse.viatra2.framework.properties.providers.DummyPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPMProperties {
    private static final long serialVersionUID = 3838142787694854860L;
    private HashMap<String, IViatraPropertyProvider> multiProperties = new HashMap();
    private Vector<IViatraPropertyProvidersChangedListener> listeners = new Vector();
    private static final String ProviderIDPrefixDelimiter = "@";

    public boolean isProviderActive(String providerID) {
        return this.multiProperties.containsKey(providerID) && this.multiProperties.get(providerID).isActive();
    }

    public void addPropertyProvider(IViatraPropertyProvider provider) {
        if (!this.multiProperties.containsKey(provider)) {
            this.multiProperties.put(provider.getProviderID(), provider);
            this.notifyListeners();
        }
    }

    public void removePropertyProvider(IViatraPropertyProvider provider) {
        if (this.multiProperties.containsKey(provider)) {
            this.multiProperties.remove(provider.getProviderID());
            this.notifyListeners();
        }
    }

    public Set<String> getAllProviderIDs() {
        return this.multiProperties.keySet();
    }

    public IViatraPropertyProvider getProvider(String providerID) {
        return this.multiProperties.get(providerID);
    }

    public Set<String> getAllRuntimePropertyIDs(String providerID) {
        return this.multiProperties.get(providerID).getAllPropertyIds();
    }

    public void setRuntimeProperty(String providerID, String propid, String value) {
        if (this.multiProperties.get(providerID) != null) {
            this.multiProperties.get(providerID).setProperty(propid, value);
        }
    }

    public String getRuntimeProperty(String providerID, String propid) {
        if (this.multiProperties.get(providerID) != null) {
            return this.multiProperties.get(providerID).getProperty(propid);
        }
        return "";
    }

    public boolean isRuntimePropertySet(String providerID, String propid) {
        try {
            return this.multiProperties.get(providerID).getProperty(propid) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void load(InputStream s) throws IOException {
        Properties p = new Properties();
        p.load(s);
        this.loadFromJavaProperties(p);
    }

    public void loadFromJavaProperties(Properties p) {
        Object[] objectArray = p.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object _key = objectArray[n2];
            String key = _key.toString();
            if (key.indexOf(ProviderIDPrefixDelimiter) >= 0) {
                String providerID = key.substring(0, key.indexOf(ProviderIDPrefixDelimiter));
                String propid = key.substring(key.indexOf(ProviderIDPrefixDelimiter) + ProviderIDPrefixDelimiter.length());
                if (!this.multiProperties.containsKey(providerID)) {
                    DummyPropertyProvider dp = new DummyPropertyProvider(providerID);
                    this.addPropertyProvider(dp);
                }
                this.setRuntimeProperty(providerID, propid, p.get(key).toString());
            }
            ++n2;
        }
    }

    public Properties getJavaProperties() {
        Properties p = new Properties();
        for (String key : this.multiProperties.keySet()) {
            IViatraPropertyProvider prov = this.multiProperties.get(key);
            for (String _key : prov.getAllPropertyIds()) {
                p.put(String.valueOf(prov.getProviderID()) + ProviderIDPrefixDelimiter + _key, prov.getProperty(_key));
            }
        }
        return p;
    }

    public void addProvideryProvidersChangedListener(IViatraPropertyProvidersChangedListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeProvideryProvidersChangedListener(IViatraPropertyProvidersChangedListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
            this.listeners.trimToSize();
        }
    }

    private void notifyListeners() {
        for (IViatraPropertyProvidersChangedListener l : this.listeners) {
            l.propertyProvidersChanged();
        }
    }
}

