/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.framework.properties.providers;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.viatra2.framework.properties.IViatraPropertyChangedListener;
import org.eclipse.viatra2.framework.properties.IViatraPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultPropertyProvider
implements IViatraPropertyProvider {
    protected Properties properties;
    protected String pID;
    protected HashSet<String> allids;
    protected HashSet<IViatraPropertyChangedListener> listeners;

    @Override
    public final void addListener(IViatraPropertyChangedListener l) {
        this.listeners.add(l);
    }

    @Override
    public final void removeListener(IViatraPropertyChangedListener l) {
        this.listeners.remove(l);
    }

    public DefaultPropertyProvider(String id) {
        this.pID = id;
        this.properties = new Properties();
        this.allids = new HashSet();
        this.listeners = new HashSet();
        this.init();
    }

    public abstract void init();

    @Override
    public final String getProviderID() {
        return this.pID;
    }

    @Override
    public final void setProperty(String id, String val) {
        String oldval = this.properties.getProperty(id);
        this.properties.put(id, val);
        this.allids.add(id);
        for (IViatraPropertyChangedListener l : this.listeners) {
            l.propertyChanged(this.pID, id, oldval, val);
        }
    }

    @Override
    public final String getProperty(String id) {
        return this.properties.getProperty(id);
    }

    @Override
    public final Set<String> getAllPropertyIds() {
        return this.allids;
    }
}

