/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.logger;

import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.viatra2.framework.properties.VPMProperties;
import org.eclipse.viatra2.logger.Logger;

public class SimpleLogger
implements Logger {
    PrintStream out = System.out;
    int level = 100;

    public void setLevel(int l) {
        this.level = l;
    }

    public void warning(String s) {
        this.message(2, s);
    }

    public void error(String s) {
        this.message(1, s);
    }

    public void debug(String s) {
        this.message(4, s);
    }

    public void fatal(String s) {
        this.message(0, s);
    }

    public void info(String s) {
        this.message(3, s);
    }

    public void init(VPMProperties props) {
        try {
            String outs = props.getRuntimeProperty("log", "output");
            this.out = outs == null || outs.equals("screen") || outs.equals("") ? System.out : new PrintStream(new FileOutputStream(outs));
        }
        catch (Exception exception) {
            System.out.println("Couldn't initialize logger.");
            System.out.println("Stopping VPM session.");
            System.exit(1);
        }
    }

    public void message(int level, String msg, Throwable cause) {
        if (this.level >= level) {
            this.out.println("[" + Logger.levelnames[level] + "] " + msg);
            if (cause != null) {
                this.out.println("[" + Logger.levelnames[level] + "] Exception stack trace follows:");
                cause.printStackTrace();
            }
        }
    }

    public void message(int level, String msg) {
        this.message(level, msg, null);
    }

    public void printStackTrace(Throwable t) {
        System.out.println("[exception track trace]");
        t.printStackTrace();
    }
}

