/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.modelChecker.impl;

import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.modelChecker.impl.ConsistencyListener;
import org.eclipse.viatra2.modelChecker.impl.ModelChecker;
import org.eclipse.viatra2.modelChecker.impl.ProblemCounter;
import org.eclipse.viatra2.tags.ITagManager;

public class ProblemManager {
    ProblemCounter pc;
    ModelChecker mc;
    IModelSpace ms;
    ConsistencyListener cli;
    ITagManager tm;

    public void init(IFramework fw) {
        this.tm = fw.getTagManager();
        this.ms = fw.getTopmodel();
        this.mc = new ModelChecker();
        if (fw.getProperties().getRuntimeProperty("Model checking", "On-the-fly model checking") != null && fw.getProperties().getRuntimeProperty("Model checking", "On-the-fly model checking").equalsIgnoreCase("true")) {
            this.pc = new ProblemCounter(this.mc.checkAllModelElement(this.ms), this);
            this.cli = new ConsistencyListener(this.pc);
            this.ms.getNotificationManager().addAllListener(this.cli);
        }
    }

    public void fullCheck() {
        if (this.pc == null) {
            this.pc = new ProblemCounter(this.mc.checkAllModelElement(this.ms), this);
        } else {
            this.pc.setProblems(this.mc.checkAllModelElement(this.ms));
        }
    }

    public void deinit() {
        if (this.cli != null) {
            this.ms.getNotificationManager().removeAllListener(this.cli);
        }
    }
}

