/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.natives;

import org.eclipse.viatra2.core.EDeleteSemantics;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="clean", remark="Deletes model elements faster than the \"delete()\" rule (recursive).", params={@NativeFunctionParameter(name="entities", type={NativeFunctionParameter.ParameterType.MODEL_ELEMENT}, isVarArg=true, description="model element references to top-level entities to be deleted.")}, returns={NativeFunctionParameter.ParameterType.BOOLEAN})
public class CleanFunction
implements ASMNativeFunction {
    private void recursive_delete(IEntity target) throws VPMCoreException {
        while (!target.getContents().isEmpty()) {
            try {
                this.recursive_delete((IEntity)target.getContents().iterator().next());
            }
            catch (ClassCastException classCastException) {
                System.out.println("Non-entity content detected at " + target.getFullyQualifiedName());
            }
        }
        target.getModelSpace().getModelManager().deleteEntity(target, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
    }

    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        try {
            Object[] objectArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                if (param instanceof IEntity) {
                    this.recursive_delete((IEntity)param);
                }
                ++n2;
            }
        }
        catch (VPMCoreException vPMCoreException) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getDescription() {
        return "Implements a fast, recursive model element delete algorithm.";
    }

    public String getID() {
        return this.getClass().getCanonicalName();
    }

    public String getName() {
        return "clean";
    }
}

