/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.natives;

import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="exists", returns={NativeFunctionParameter.ParameterType.BOOLEAN}, remark="The 'ref' rule throws an exception if a non-existing model element is passed as the parameter, whereas this native function returns \"false\" in that case.", params={@NativeFunctionParameter(name="elements", description="FQNs of model elements to be checked for existence", isVarArg=true, type={NativeFunctionParameter.ParameterType.STRING})})
public class ExistsFunction
implements ASMNativeFunction {
    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        boolean allOK = true;
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object ref = objectArray[n2];
            if (ref instanceof String) {
                allOK &= msp.getModelManager().getElementByName((String)ref) != null;
            } else {
                throw new VPMRuntimeException("Parameter type mismatch!");
            }
            ++n2;
        }
        return allOK;
    }

    public String getName() {
        return "exists";
    }

    public String getDescription() {
        return "checks for the existence of model elements; returns \"true\" if all parameters exist, \"false\" otherwise";
    }

    public String getID() {
        return this.getClass().getCanonicalName();
    }
}

