/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.natives;

import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="measureMemoryFootprint", returns={NativeFunctionParameter.ParameterType.INTEGER}, remark="Returns the heaps size measured after Garbage Collection. Caution: Garbage Collector runs are initiated before measurement, which may have a severe runtime impact.", params={@NativeFunctionParameter(name="gcRuns", description="The number of GC runs to be initiated before measurement.", type={NativeFunctionParameter.ParameterType.INTEGER})})
public class MeasureMemoryFootprintFunction
implements ASMNativeFunction {
    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        if (params.length != 1) {
            throw new VPMRuntimeException("Illegal parameter number for measureMemoryFootprint(): a single parameter is required");
        }
        if (!(params[0] instanceof Integer)) {
            throw new VPMRuntimeException("Illegal argument type for measureMemoryFootprint(): Integer is required");
        }
        Integer gcRuns = (Integer)params[0];
        int i = 0;
        while (i < gcRuns) {
            Runtime.getRuntime().gc();
            ++i;
        }
        return (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
    }

    public String getDescription() {
        return "Returns the heaps size measured after Garbage Collection. Caution: Garbage Collector runs are initiated before measurement, which may have a severe runtime impact.";
    }

    public String getID() {
        return this.getClass().getCanonicalName();
    }

    public String getName() {
        return "measureMemoryFootprint";
    }
}

