/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.natives;

import java.util.Random;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="randomInteger", remark="Returns a fresh random non-negative integer less than the argument, or a random integer without range restriction if no argument is provided.", params={@NativeFunctionParameter(type={NativeFunctionParameter.ParameterType.INTEGER}, name="range", description="the upper limit of the random integers, omit if full range is required")}, returns={NativeFunctionParameter.ParameterType.INTEGER})
public class RandomIntegerFunction
implements ASMNativeFunction {
    Random random = new Random();

    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        if (params.length > 0 && params[0] != null && params[0] instanceof Integer) {
            return this.random.nextInt((Integer)params[0]);
        }
        return this.random.nextInt();
    }

    public String getDescription() {
        return "Returns a fresh random non-negative integer less than the range argument, or a random integer without range restriction if no argument is provided.";
    }

    public String getID() {
        return this.getClass().getCanonicalName();
    }

    public String getName() {
        return "randomInteger";
    }
}

