/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.natives;

import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="systime", remark="Returns a truncated systime to fit into a 32-bit integer. First 4 digits are dropped.", params={}, returns={NativeFunctionParameter.ParameterType.STRING})
public class SysTimeFunction
implements ASMNativeFunction {
    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        return new Integer(Long.toString(System.currentTimeMillis()).substring(4));
    }

    public String getDescription() {
        return "The current system time in milliseconds (with first 4 digits dropped).";
    }

    public String getID() {
        return this.getClass().getCanonicalName();
    }

    public String getName() {
        return "systime";
    }
}

