/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.editor.text;

import java.util.HashSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.viatra2.editor.text.light.VTCLEditor;
import org.eclipse.viatra2.editor.text.light.VTMLEditor;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkListChangedListener;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IFrameworkListChangedListener {
    public static final String PLUGIN_ID = "org.eclipse.viatra2.editor.text";
    private static Activator plugin;
    boolean listenerRegistered = false;
    HashSet<VTCLEditor> editors = new HashSet();
    protected VTCLEditor iCurrentVTCLEditor;
    protected VTMLEditor iCurrentVTMLEditor;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public VTCLEditor getCurrentVTCLEditor() {
        return this.iCurrentVTCLEditor;
    }

    public void setCurrentVTCLEditor(VTCLEditor ed) {
        if (!this.listenerRegistered) {
            FrameworkManager.getInstance().addFrameworkListChangedListener((IFrameworkListChangedListener)this);
            this.listenerRegistered = true;
        }
        this.iCurrentVTCLEditor = ed;
        if (!this.editors.contains((Object)ed)) {
            this.addEditor(ed);
        }
    }

    public void addEditor(VTCLEditor ed) {
        this.editors.add(ed);
    }

    public void removeEditor(VTCLEditor ed) {
        this.editors.remove((Object)ed);
    }

    public VTMLEditor getCurrentVTMLEditor() {
        return this.iCurrentVTMLEditor;
    }

    public void setCurrentVTMLEditor(VTMLEditor ed) {
        this.iCurrentVTMLEditor = ed;
    }

    public void frameworkAdded(IFramework f) {
    }

    public void frameworkRemoved(IFramework f) {
        for (VTCLEditor e : this.editors) {
            if (!f.equals(e.getAttachedFramework())) continue;
            e.setAttachedFramework(null);
            e.refreshTitle();
        }
    }
}

