/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.editor.text.light;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.JavaPairMatcher;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.viatra2.editor.text.Activator;
import org.eclipse.viatra2.editor.text.light.VTEColorProvider;
import org.eclipse.viatra2.editor.text.light.vtcl.QuickLoadVTCLAction;
import org.eclipse.viatra2.editor.text.light.vtcl.QuickRunVTCLAction;
import org.eclipse.viatra2.editor.text.light.vtcl.VTCLConfiguration;
import org.eclipse.viatra2.editor.text.light.vtcl.VTCLMarkerManager;
import org.eclipse.viatra2.editor.text.markers.IVTCLErrorReporter;
import org.eclipse.viatra2.errors.info.ErrorInformation;
import org.eclipse.viatra2.framework.Framework;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Module;
import org.eclipse.viatra2.lpgparser.loader.VTCLParseController;
import org.eclipse.viatra2.lpgparser.loader.VTCLParserManager;

public class VTCLEditor
extends TextEditor {
    private VTEColorProvider iColorProvider = new VTEColorProvider();
    protected QuickLoadVTCLAction iQuickParseAction;
    protected QuickRunVTCLAction iQuickRunAction;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')'};
    protected MatchingCharacterPainter fBracketPainter;
    private PaintManager fPaintManager;
    private VTCLParseController fParseController;
    private VTCLMarkerManager fMarkerManager;
    private IFramework attachedFramework;
    private Module module;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fPaintManager = new PaintManager((ITextViewer)this.getSourceViewer());
        this.startBracketHighlighting();
        this.fParseController = null;
        this.fMarkerManager = new VTCLMarkerManager();
    }

    public IVTCLErrorReporter getMarkerManager() {
        return this.fMarkerManager;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.attachEditor();
        this.parseOnSave();
    }

    public IFramework getAttachedFramework() {
        return this.attachedFramework;
    }

    public void setAttachedFramework(IFramework fw) {
        this.attachedFramework = fw;
    }

    public Module getModule() {
        return this.module;
    }

    public String getPartName() {
        String t = super.getPartName();
        if (this.attachedFramework != null) {
            t = String.valueOf(t) + " (" + this.attachedFramework.getId() + ")";
        }
        return t;
    }

    private void startBracketHighlighting() {
        if (this.fBracketPainter == null) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            this.fBracketPainter = new MatchingCharacterPainter(sourceViewer, (ICharacterPairMatcher)new JavaPairMatcher(BRACKETS));
            this.fBracketPainter.setColor(new Color(null, 0, 0, 128));
            this.fPaintManager.addPainter((IPainter)this.fBracketPainter);
        }
    }

    private void stopBracketHighlighting() {
        if (this.fBracketPainter != null) {
            this.fPaintManager.removePainter((IPainter)this.fBracketPainter);
            this.fBracketPainter.deactivate(true);
            this.fBracketPainter.dispose();
            this.fBracketPainter = null;
        }
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public VTCLEditor() {
        this.setSourceViewerConfiguration(new VTCLConfiguration(this.iColorProvider));
    }

    protected void createActions() {
        super.createActions();
        this.iQuickParseAction = new QuickLoadVTCLAction();
        this.setAction("quickparse", (IAction)this.iQuickParseAction);
        this.iQuickRunAction = new QuickRunVTCLAction();
        this.setAction("quickload", (IAction)this.iQuickRunAction);
    }

    public void updateActions() {
    }

    public void setFocus() {
        super.setFocus();
        this.updateActions();
        Activator.getDefault().setCurrentVTCLEditor(this);
    }

    public void dispose() {
        this.iColorProvider.dispose();
        this.stopBracketHighlighting();
        Activator.getDefault().removeEditor(this);
        super.dispose();
    }

    public void attachEditor() {
        if (this.attachedFramework == null) {
            final String[] allfws = FrameworkManager.getInstance().getAllFrameWorks();
            if (allfws.length < 1) {
                this.firePropertyChange(1);
                return;
            }
            if (allfws.length == 1) {
                this.attachedFramework = FrameworkManager.getInstance().getFramework(allfws[0]);
                this.firePropertyChange(1);
            } else {
                Object[] o;
                ListDialog dialog = new ListDialog(this.getSite().getShell());
                dialog.setTitle("Select modelspace to attach");
                dialog.setAddCancelButton(true);
                dialog.setBlockOnOpen(true);
                dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        Framework framework = FrameworkManager.getInstance().getFramework((String)element);
                        String filename = framework.getCurrentFilename();
                        filename = filename.substring(filename.lastIndexOf(47) + 1);
                        return String.valueOf(super.getText(element)) + " (" + filename + ")";
                    }
                });
                dialog.setContentProvider(new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return allfws;
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                });
                dialog.setInput((Object)"blablabla");
                int result = dialog.open();
                if (result == 0 && (o = dialog.getResult()) != null && o.length == 1) {
                    String id = o[0].toString();
                    this.attachedFramework = FrameworkManager.getInstance().getFramework(id);
                    this.firePropertyChange(1);
                }
            }
        } else {
            this.firePropertyChange(1);
        }
    }

    public void refreshTitle() {
        this.firePropertyChange(1);
    }

    public void parseOnSave() {
        block9: {
            if (this.attachedFramework != null) {
                try {
                    this.executeParsing(false);
                    if (this.fParseController != null) {
                        Machine old;
                        if (!this.fParseController.hasErrors()) {
                            if (this.fParseController.getModule() != null) {
                                Machine newm = this.fParseController.getMachine();
                                Machine old2 = (Machine)this.attachedFramework.getMachineByFQN(newm.getFqn());
                                if (old2 != null) {
                                    this.attachedFramework.removeMachine(old2.getFqn());
                                }
                                this.attachedFramework.addMachine(newm.getFqn(), (Object)newm);
                                this.module = this.fParseController.getModule();
                            }
                        } else if (this.fParseController.getMachine() != null && (old = (Machine)this.attachedFramework.getMachineByFQN(this.fParseController.getMachine().getFqn())) != null) {
                            this.attachedFramework.removeMachine(old.getFqn());
                        }
                    }
                }
                catch (Exception e) {
                    if (e.getMessage() == null) break block9;
                    this.attachedFramework.getLogger().fatal(e.getMessage());
                }
            }
        }
    }

    public void executeParsing(boolean isParseOnly) {
        block7: {
            try {
                IEditorInput editorInput = this.getEditorInput();
                IFile file = null;
                String fileName = null;
                VTCLEditor iEditor = Activator.getDefault().getCurrentVTCLEditor();
                if (iEditor == null) {
                    return;
                }
                if (editorInput instanceof IFileEditorInput) {
                    IFileEditorInput fileEditorInput = (IFileEditorInput)this.getEditorInput();
                    file = fileEditorInput.getFile();
                    fileName = file.getLocation().toOSString();
                    this.fMarkerManager.deleteMarkers((IResource)file, "org.eclipse.core.resources.problemmarker");
                    this.fMarkerManager.initialize(iEditor.getViewer(), file);
                    VTCLParserManager parserManager = (VTCLParserManager)this.attachedFramework.getVTCLParserManager();
                    this.fParseController = parserManager.lookupAndCreateParseController(fileName);
                    if (isParseOnly) {
                        this.fParseController.parseOnly();
                    } else {
                        this.fParseController.parseAndBuild();
                    }
                    for (ErrorInformation error : this.fParseController.getErrors()) {
                        this.fMarkerManager.reportError(error);
                    }
                }
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block7;
                this.attachedFramework.getLogger().fatal("Parsing failed for input " + this.getEditorInput().getName());
            }
        }
    }
}

