/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.actions.ViatraTreeEditorSelectionAction;
import org.eclipse.viatra2.treeeditor.commands.DeleteModelElementCommand;
import org.eclipse.viatra2.treeeditor.commands.ViatraCompoundCommand;

public class LocalDeleteAction
extends ViatraTreeEditorSelectionAction {
    public static final String ID = "ViatraTreeEditor.Actions.LocalDeleteAction";

    public LocalDeleteAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText("Delete");
        this.setToolTipText("Delete the model element");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setHoverImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
    }

    public void run() {
        ViatraTreeEditor iVTE = (ViatraTreeEditor)this.iPart;
        ViatraCompoundCommand ccmd = new ViatraCompoundCommand();
        for (Object o : ((IStructuredSelection)iVTE.getSite().getSelectionProvider().getSelection()).toList()) {
            IModelElement me = (IModelElement)o;
            DeleteModelElementCommand cmd = new DeleteModelElementCommand();
            if (me instanceof IEntity) {
                cmd.setEntity((IEntity)me);
            } else {
                cmd.setRelation((IRelation)me);
            }
            ccmd.add(cmd);
        }
        if (!ccmd.isEmpty()) {
            iVTE.getCommandStack().execute(ccmd);
            iVTE.updateActions();
        }
    }

    public void updateSelf() {
        if (this.getSelectedObjects().size() == 1 && this.getSelectedObjects().getFirstElement() instanceof IModelElement) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

