/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.actions;

import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.treeeditor.Plugin;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.actions.ViatraTreeEditorSelectionAction;
import org.eclipse.viatra2.treeeditor.commands.AddModelElementCommand;

public class NewRelationAction
extends ViatraTreeEditorSelectionAction {
    public static final String ID = "ViatraTreeEditor.Actions.NewRelationAction";

    public NewRelationAction(IWorkbenchPart part) {
        super(part);
        this.setText("Add Relation");
        this.setToolTipText("Create a new relation with the selected model element as its source and target.");
        this.setImageDescriptor(Plugin.getImageDescriptor("icons/relation_transparent.png"));
    }

    public void run() {
        IModelElement source = (IModelElement)this.getSelectedObjects().toList().get(0);
        AddModelElementCommand cmd = new AddModelElementCommand();
        cmd.setSource(source);
        ((ViatraTreeEditor)this.iPart).getCommandStack().execute(cmd);
        ((ViatraTreeEditor)this.iPart).updateActions();
    }

    public void updateSelf() {
        if (this.getSelectedObjects().size() == 1 && this.getSelectedObjects().getFirstElement() instanceof IModelElement) {
            String s = ((IModelElement)this.getSelectedObjects().getFirstElement()).getFullyQualifiedName();
            if (s != null && s.length() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }
}

