/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.actions;

import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.treeeditor.Plugin;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.actions.ViatraTreeEditorSelectionAction;
import org.eclipse.viatra2.treeeditor.providers.ViatraTreeEventListener;

public class RenameAction
extends ViatraTreeEditorSelectionAction {
    public static final String ID = "ViatraTreeEditor.Actions.RenameAction";

    public RenameAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText("Rename");
        this.setToolTipText("Change the model elements' (local) name");
        this.setImageDescriptor(Plugin.getImageDescriptor("icons/rename.png"));
    }

    public void run() {
        ViatraTreeEditor iVTE = (ViatraTreeEditor)this.iPart;
        Tree iTreeControl = iVTE.getTreeViewer().getTree();
        TreeItem item = iTreeControl.getSelection()[0];
        if (item == null) {
            return;
        }
        IModelElement me = (IModelElement)item.getData();
        TreeEditor editor = new TreeEditor(iTreeControl);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 64;
        ViatraTreeEventListener list = new ViatraTreeEventListener(me, editor, iVTE);
        Text celleditor = new Text((Composite)iTreeControl, 0);
        celleditor.setText(me.getName());
        celleditor.addFocusListener((FocusListener)list);
        celleditor.addKeyListener((KeyListener)list);
        celleditor.addModifyListener((ModifyListener)list);
        celleditor.selectAll();
        celleditor.setFocus();
        editor.setEditor((Control)celleditor, item);
    }

    public void updateSelf() {
        if (this.getSelectedObjects().size() == 1 && this.getSelectedObjects().getFirstElement() instanceof IModelElement) {
            String s = ((IModelElement)this.getSelectedObjects().getFirstElement()).getFullyQualifiedName();
            if (s != null && s.length() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }
}

