/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.actions.ViatraRetargetAction;
import org.eclipse.viatra2.treeeditor.commands.DeleteModelElementCommand;
import org.eclipse.viatra2.treeeditor.commands.ViatraCompoundCommand;

public class ViatraDeleteAction
extends ViatraRetargetAction {
    public ViatraDeleteAction() {
        super(ActionFactory.DELETE.getId(), "Delete model element");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setHoverImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
    }

    public void run() {
        ViatraCompoundCommand ccmd = new ViatraCompoundCommand();
        for (Object o : ((IStructuredSelection)this.iVTE.getSite().getSelectionProvider().getSelection()).toList()) {
            IModelElement me = (IModelElement)o;
            DeleteModelElementCommand cmd = new DeleteModelElementCommand();
            if (me instanceof IEntity) {
                cmd.setEntity((IEntity)me);
            } else {
                cmd.setRelation((IRelation)me);
            }
            ccmd.add(cmd);
        }
        if (!ccmd.isEmpty()) {
            this.iVTE.getCommandStack().execute(ccmd);
            this.iVTE.updateActions();
        }
    }

    public void updateSelf(ViatraTreeEditor vte) {
        super.updateSelf(vte);
        if (vte.getSite().getSelectionProvider().getSelection() instanceof IStructuredSelection) {
            boolean res = false;
            for (Object o : (IStructuredSelection)vte.getSite().getSelectionProvider().getSelection()) {
                if (o == null || !(o instanceof IModelElement) || ((IModelElement)o).getFullyQualifiedName() == null || ((IModelElement)o).getFullyQualifiedName().length() <= 0) continue;
                res = true;
                break;
            }
            this.setEnabled(res);
        } else {
            this.setEnabled(false);
        }
    }
}

