/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.commands;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.treeeditor.commands.ViatraEditorCommand;

public class RetargetRelationCommand
extends ViatraEditorCommand {
    private IModelElement newtarget;
    private IModelElement oldtarget;
    private IRelation relation;
    private String newtarget_name;
    private String oldtarget_name;
    private String relation_name;
    private String relation_oldname;

    public void setRelation(IRelation aRel, IModelElement aNewTarget) {
        this.relation = aRel;
        this.oldtarget = this.relation.getTo();
        this.newtarget = aNewTarget;
        this.relation_name = this.relation.getFullyQualifiedName();
        this.oldtarget_name = this.oldtarget.getFullyQualifiedName();
        this.newtarget_name = this.newtarget.getFullyQualifiedName();
    }

    public void execute() throws VPMCoreException {
        this.newtarget = this.Lookup(this.newtarget, this.newtarget_name);
        this.oldtarget = this.Lookup(this.oldtarget, this.oldtarget_name);
        this.relation = (IRelation)this.Lookup((IModelElement)this.relation, this.relation_name);
        if (this.relation != null && this.oldtarget != null && this.newtarget != null) {
            this.iTransactionID = this.relation.getModelSpace().getTransactionManager().beginUndoableTransaction();
            this.relation.getModelSpace().getModelManager().setRelationTo(this.relation, this.newtarget);
            this.relation_oldname = this.relation_name;
            this.relation_name = this.relation.getFullyQualifiedName();
            this.relation.getModelSpace().getTransactionManager().commitTransaction();
        }
    }

    public void undo() {
        this.newtarget = this.Lookup(this.newtarget, this.newtarget_name);
        this.oldtarget = this.Lookup(this.oldtarget, this.oldtarget_name);
        this.relation = (IRelation)this.Lookup((IModelElement)this.relation, this.relation_name);
        if (this.relation != null && this.oldtarget != null && this.newtarget != null) {
            this.relation.getModelSpace().getTransactionManager().undoTransaction(this.iTransactionID);
            this.relation_name = this.relation_oldname;
        }
    }
}

