/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.tags.ITag;
import org.eclipse.viatra2.tags.TagKind;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.commands.AddSupertypeCommand;
import org.eclipse.viatra2.treeeditor.commands.AddTypeCommand;
import org.eclipse.viatra2.treeeditor.commands.ChangeElementNameCommand;
import org.eclipse.viatra2.treeeditor.commands.ChangePropertyCommand;
import org.eclipse.viatra2.treeeditor.commands.MoveModelElementCommand;
import org.eclipse.viatra2.treeeditor.commands.RemoveSupertypeCommand;
import org.eclipse.viatra2.treeeditor.commands.RemoveTypeCommand;
import org.eclipse.viatra2.treeeditor.commands.RetargetRelationCommand;
import org.eclipse.viatra2.treeeditor.commands.ViatraCompoundCommand;
import org.eclipse.viatra2.treeeditor.commands.ViatraEditorCommand;
import org.eclipse.viatra2.treeeditor.properties.VPMProperties;
import org.eclipse.viatra2.treeeditor.properties.VPMPropertyCategory;
import org.eclipse.viatra2.treeeditor.properties.descriptors.FQNListPropertyDescriptor;
import org.eclipse.viatra2.treeeditor.properties.descriptors.FQNPropertyDescriptor;
import org.eclipse.viatra2.treeeditor.properties.util.LabelTranslator;
import org.eclipse.viatra2.treeeditor.properties.util.LegacyHelper;
import org.eclipse.viatra2.treeeditor.properties.validators.DelimitedFQNListValidator;
import org.eclipse.viatra2.treeeditor.properties.validators.FQNValidator;
import org.eclipse.viatra2.treeeditor.properties.validators.LocalNameValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPMPropertySource
implements IPropertySource2 {
    static final String[] boolChoice = new String[]{"false", "true"};
    static final String[] multiplicityChoice = new String[]{"many to many", "many to one", "one to many", "one to one"};
    IModelElement iElement;
    ViatraTreeEditor iEditor;
    static Integer Int0 = new Integer(0);
    static Integer Int1 = new Integer(1);
    static String EmptyString = new String("");

    public VPMPropertySource(IModelElement e, ViatraTreeEditor ed) {
        this.iElement = e;
        this.iEditor = ed;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> r = new ArrayList<TextPropertyDescriptor>();
        TextPropertyDescriptor d = null;
        d = new TextPropertyDescriptor((Object)VPMProperties.NAME, LabelTranslator.getPropertyName(VPMProperties.NAME));
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.NAMING_VALUES));
        d.setValidator((ICellEditorValidator)new LocalNameValidator(this.iElement));
        r.add(d);
        d = new TextPropertyDescriptor((Object)VPMProperties.FQN, LabelTranslator.getPropertyName(VPMProperties.FQN));
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.NAMING_VALUES));
        r.add(d);
        d = new PropertyDescriptor((Object)VPMProperties.WARNINGS, LabelTranslator.getPropertyName(VPMProperties.WARNINGS));
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.TAGS));
        r.add(d);
        d = new PropertyDescriptor((Object)VPMProperties.INFOTAGS, LabelTranslator.getPropertyName(VPMProperties.INFOTAGS));
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.TAGS));
        r.add(d);
        if (this.iElement.isEntity()) {
            d = new TextPropertyDescriptor((Object)VPMProperties.VALUE, LabelTranslator.getPropertyName(VPMProperties.VALUE));
            d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.NAMING_VALUES));
            r.add(d);
        }
        d = new TextPropertyDescriptor((Object)VPMProperties.VIEWINFO, LabelTranslator.getPropertyName(VPMProperties.VIEWINFO));
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.NAMING_VALUES));
        r.add(d);
        d = new FQNListPropertyDescriptor((Object)VPMProperties.TYPE, LabelTranslator.getPropertyName(VPMProperties.TYPE), this.iElement);
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.TYPES_SUPERTYPES));
        d.setValidator((ICellEditorValidator)new DelimitedFQNListValidator(this.iElement));
        r.add(d);
        d = new FQNListPropertyDescriptor((Object)VPMProperties.SUPERTYPE, LabelTranslator.getPropertyName(VPMProperties.SUPERTYPE), this.iElement);
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.TYPES_SUPERTYPES));
        d.setValidator((ICellEditorValidator)new DelimitedFQNListValidator(this.iElement));
        r.add(d);
        d = new FQNListPropertyDescriptor((Object)VPMProperties.INSTANCE, LabelTranslator.getPropertyName(VPMProperties.INSTANCE), this.iElement);
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.TYPES_SUPERTYPES));
        d.setValidator((ICellEditorValidator)new DelimitedFQNListValidator(this.iElement));
        r.add(d);
        d = new FQNListPropertyDescriptor((Object)VPMProperties.SUBTYPE, LabelTranslator.getPropertyName(VPMProperties.SUBTYPE), this.iElement);
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.TYPES_SUPERTYPES));
        d.setValidator((ICellEditorValidator)new DelimitedFQNListValidator(this.iElement));
        r.add(d);
        d = new ComboBoxPropertyDescriptor((Object)VPMProperties.ISFINALTYPE, LabelTranslator.getPropertyName(VPMProperties.ISFINALTYPE), boolChoice);
        d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.TYPES_SUPERTYPES));
        r.add(d);
        if (this.iElement.isRelation()) {
            d = new FQNPropertyDescriptor((Object)VPMProperties.SOURCE, LabelTranslator.getPropertyName(VPMProperties.SOURCE), this.iElement);
            d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.RELATIONS));
            d.setValidator((ICellEditorValidator)new FQNValidator(this.iElement));
            r.add(d);
            d = new FQNPropertyDescriptor((Object)VPMProperties.TARGET, LabelTranslator.getPropertyName(VPMProperties.TARGET), this.iElement);
            d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.RELATIONS));
            d.setValidator((ICellEditorValidator)new FQNValidator(this.iElement));
            r.add(d);
            d = new ComboBoxPropertyDescriptor((Object)VPMProperties.ISAGGREGATION, LabelTranslator.getPropertyName(VPMProperties.ISAGGREGATION), boolChoice);
            d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.RELATIONS));
            r.add(d);
            d = new ComboBoxPropertyDescriptor((Object)VPMProperties.MULTIPLICITY, LabelTranslator.getPropertyName(VPMProperties.MULTIPLICITY), multiplicityChoice);
            d.setCategory(LabelTranslator.getCategoryName(VPMPropertyCategory.RELATIONS));
            r.add(d);
        }
        return r.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        switch ((VPMProperties)((Object)id)) {
            case NAME: {
                return this.iElement.getName();
            }
            case FQN: {
                return this.iElement.getFullyQualifiedName();
            }
            case VALUE: {
                return ((IEntity)this.iElement).getValue();
            }
            case VIEWINFO: {
                return this.iElement.getViewInfo() != null ? this.iElement.getViewInfo() : EmptyString;
            }
            case TYPE: {
                return LegacyHelper.getTypesAsString(this.iElement);
            }
            case INSTANCE: {
                return LegacyHelper.getInstancesAsString(this.iElement);
            }
            case SUPERTYPE: {
                return LegacyHelper.getSupertypesAsString(this.iElement);
            }
            case SUBTYPE: {
                return LegacyHelper.getSubtypesAsString(this.iElement);
            }
            case ISFINALTYPE: {
                return this.iElement.getIsFinalType() ? Int1 : Int0;
            }
            case SOURCE: {
                return ((IRelation)this.iElement).getFrom().getFullyQualifiedName();
            }
            case TARGET: {
                return ((IRelation)this.iElement).getTo().getFullyQualifiedName();
            }
            case ISAGGREGATION: {
                return ((IRelation)this.iElement).getIsAggregation() ? Int1 : Int0;
            }
            case MULTIPLICITY: {
                return ((IRelation)this.iElement).getMultiplicity().ordinal();
            }
            case WARNINGS: {
                String warnings = "";
                Set tags = this.iEditor.getFramework().getTagManager().getTagsForModelElement(this.iElement);
                if (tags != null) {
                    for (ITag t : tags) {
                        if (!t.getKind().equals((Object)TagKind.MODELING_PROBLEM)) continue;
                        warnings = String.valueOf(warnings) + t.getMessage() + "; ";
                    }
                }
                return warnings;
            }
            case INFOTAGS: {
                String infos = "";
                Set _tags = this.iEditor.getFramework().getTagManager().getTagsForModelElement(this.iElement);
                if (_tags != null) {
                    for (ITag t : _tags) {
                        if (!t.getKind().equals((Object)TagKind.MODELING_INFO)) continue;
                        infos = String.valueOf(infos) + t.getMessage() + "; ";
                    }
                }
                return infos;
            }
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        ViatraEditorCommand cmd = null;
        switch ((VPMProperties)((Object)id)) {
            case NAME: {
                ChangeElementNameCommand c = new ChangeElementNameCommand();
                c.setNewElemName(value.toString());
                c.setTargetElem(this.iElement);
                cmd = c;
                break;
            }
            case VALUE: {
                ChangePropertyCommand c1 = new ChangePropertyCommand();
                c1.setKind(VPMProperties.VALUE);
                c1.setNewValue(value.toString());
                c1.setTarget(this.iElement);
                cmd = c1;
                break;
            }
            case VIEWINFO: {
                ChangePropertyCommand c2 = new ChangePropertyCommand();
                c2.setKind(VPMProperties.VIEWINFO);
                c2.setNewValue(value.toString());
                c2.setTarget(this.iElement);
                cmd = c2;
                break;
            }
            case ISFINALTYPE: {
                ChangePropertyCommand c3 = new ChangePropertyCommand();
                c3.setKind(VPMProperties.ISFINALTYPE);
                c3.setIntValue((Integer)value);
                c3.setTarget(this.iElement);
                cmd = c3;
                break;
            }
            case ISAGGREGATION: {
                ChangePropertyCommand c4 = new ChangePropertyCommand();
                c4.setKind(VPMProperties.ISAGGREGATION);
                c4.setIntValue((Integer)value);
                c4.setTarget(this.iElement);
                cmd = c4;
                break;
            }
            case MULTIPLICITY: {
                ChangePropertyCommand c5 = new ChangePropertyCommand();
                c5.setKind(VPMProperties.MULTIPLICITY);
                c5.setIntValue((Integer)value);
                c5.setTarget(this.iElement);
                cmd = c5;
                break;
            }
            case SOURCE: {
                IModelElement newSrc = this.iElement.getModelSpace().getModelManager().getElementByName(value.toString());
                if (newSrc == null) break;
                MoveModelElementCommand c6 = new MoveModelElementCommand();
                c6.setRelation((IRelation)this.iElement, newSrc);
                cmd = c6;
                break;
            }
            case TARGET: {
                IModelElement newTrg = this.iElement.getModelSpace().getModelManager().getElementByName(value.toString());
                if (newTrg == null) break;
                RetargetRelationCommand c7 = new RetargetRelationCommand();
                c7.setRelation((IRelation)this.iElement, newTrg);
                cmd = c7;
                break;
            }
            case TYPE: {
                ViatraEditorCommand _c;
                Set<IModelElement> newSet = this.clean_split(value.toString());
                if (newSet == null) {
                    return;
                }
                HashSet oldSet = new HashSet();
                oldSet.addAll(this.iElement.getTypes());
                HashSet _oldSet = (HashSet)oldSet.clone();
                oldSet.removeAll(newSet);
                newSet.removeAll(_oldSet);
                ViatraCompoundCommand cc = new ViatraCompoundCommand();
                for (IModelElement staleType : oldSet) {
                    _c = new RemoveTypeCommand();
                    ((RemoveTypeCommand)_c).setTargetElem(this.iElement);
                    ((RemoveTypeCommand)_c).setTypeElem(staleType);
                    cc.add(_c);
                }
                for (IModelElement newType : newSet) {
                    _c = new AddTypeCommand();
                    ((AddTypeCommand)_c).setTargetElem(this.iElement);
                    ((AddTypeCommand)_c).setTypeElem(newType);
                    cc.add(_c);
                }
                cmd = cc;
                break;
            }
            case INSTANCE: {
                ViatraEditorCommand _c;
                Set<IModelElement> newSet = this.clean_split(value.toString());
                if (newSet == null) {
                    return;
                }
                HashSet oldSet = new HashSet();
                oldSet.addAll(this.iElement.getInstances());
                HashSet _oldSet = (HashSet)oldSet.clone();
                oldSet.removeAll(newSet);
                newSet.removeAll(_oldSet);
                ViatraCompoundCommand cc = new ViatraCompoundCommand();
                for (IModelElement staleType : oldSet) {
                    _c = new RemoveTypeCommand();
                    ((RemoveTypeCommand)_c).setTargetElem(staleType);
                    ((RemoveTypeCommand)_c).setTypeElem(this.iElement);
                    cc.add(_c);
                }
                for (IModelElement newType : newSet) {
                    _c = new AddTypeCommand();
                    ((AddTypeCommand)_c).setTargetElem(newType);
                    ((AddTypeCommand)_c).setTypeElem(this.iElement);
                    cc.add(_c);
                }
                cmd = cc;
                break;
            }
            case SUPERTYPE: {
                ViatraEditorCommand _c;
                Set<IModelElement> newSet = this.clean_split(value.toString());
                if (newSet == null) {
                    return;
                }
                HashSet oldSet = new HashSet();
                oldSet.addAll(this.iElement.getSupertypes());
                HashSet _oldSet = (HashSet)oldSet.clone();
                oldSet.removeAll(newSet);
                newSet.removeAll(_oldSet);
                ViatraCompoundCommand cc = new ViatraCompoundCommand();
                for (IModelElement staleType : oldSet) {
                    _c = new RemoveSupertypeCommand();
                    ((RemoveSupertypeCommand)_c).setTargetElem(this.iElement);
                    ((RemoveSupertypeCommand)_c).setSupertypeElem(staleType);
                    cc.add(_c);
                }
                for (IModelElement newType : newSet) {
                    _c = new AddSupertypeCommand();
                    ((AddSupertypeCommand)_c).setTargetElem(this.iElement);
                    ((AddSupertypeCommand)_c).setSupertypeElem(newType);
                    cc.add(_c);
                }
                cmd = cc;
                break;
            }
            case SUBTYPE: {
                ViatraEditorCommand _c;
                Set<IModelElement> newSet = this.clean_split(value.toString());
                if (newSet == null) {
                    return;
                }
                HashSet oldSet = new HashSet();
                oldSet.addAll(this.iElement.getSubtypes());
                HashSet _oldSet = (HashSet)oldSet.clone();
                oldSet.removeAll(newSet);
                newSet.removeAll(_oldSet);
                ViatraCompoundCommand cc = new ViatraCompoundCommand();
                for (IModelElement staleType : oldSet) {
                    _c = new RemoveSupertypeCommand();
                    ((RemoveSupertypeCommand)_c).setTargetElem(staleType);
                    ((RemoveSupertypeCommand)_c).setSupertypeElem(this.iElement);
                    cc.add(_c);
                }
                for (IModelElement newType : newSet) {
                    _c = new AddSupertypeCommand();
                    ((AddSupertypeCommand)_c).setTargetElem(newType);
                    ((AddSupertypeCommand)_c).setSupertypeElem(this.iElement);
                    cc.add(_c);
                }
                cmd = cc;
            }
        }
        if (cmd != null) {
            this.iEditor.getCommandStack().execute(cmd);
        }
    }

    private Set<IModelElement> clean_split(String s) {
        String[] elements = s.replaceAll("[\\s]", "").split("[,;]");
        return LegacyHelper.convertStringArrayToSetOfElements(elements, false, this.iElement.getModelSpace().getModelManager());
    }
}

