/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.properties.descriptors;

import java.util.ArrayList;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.viatra2.core.IModelElement;

public class FQNListPropertyDescriptor
extends TextPropertyDescriptor {
    IModelElement iElement;

    public FQNListPropertyDescriptor(Object id, String displayName, IModelElement element) {
        super(id, displayName);
        this.iElement = element;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new FQNListCellEditor(parent);
    }

    public class FQNContentProposal
    implements IContentProposal {
        IModelElement e;
        int origPosition;

        public FQNContentProposal(IModelElement aE, int origPos) {
            this.e = aE;
            this.origPosition = origPos;
        }

        public String getContent() {
            return this.e.getFullyQualifiedName().substring(this.origPosition);
        }

        public int getCursorPosition() {
            return this.getContent().length();
        }

        public String getDescription() {
            return "A fully qualified name whose prefix matches the content.";
        }

        public String getLabel() {
            return this.e.getFullyQualifiedName();
        }
    }

    public class FQNListCellEditor
    extends TextCellEditor {
        public FQNListCellEditor(Composite parent) {
            super(parent);
        }

        protected Control createControl(Composite parent) {
            Control c = super.createControl(parent);
            try {
                new ContentProposalAdapter(c, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new FQNListContentProposalProvider(), null, null);
            }
            catch (Exception exception) {}
            return c;
        }
    }

    public class FQNListContentProposalProvider
    implements IContentProposalProvider {
        public IContentProposal[] getProposals(String contents, int position) {
            int begin_pos1 = Math.max(0, contents.substring(0, position).lastIndexOf(";"));
            int begin_pos2 = Math.max(0, contents.substring(0, position).lastIndexOf(","));
            int end_pos1 = position + Math.max(0, contents.substring(position).lastIndexOf(";"));
            int end_pos2 = position + Math.max(0, contents.substring(position).lastIndexOf(","));
            int begin = Math.max(begin_pos1, begin_pos2) > 0 ? Math.max(begin_pos1, begin_pos2) + 1 : Math.max(begin_pos1, begin_pos2);
            while (Character.isWhitespace(contents.charAt(begin))) {
                ++begin;
            }
            String target = contents.substring(begin, Math.min(end_pos1, end_pos2));
            String validFQN = target.substring(0, Math.max(0, target.lastIndexOf(".")));
            String remainder = target.substring(target.lastIndexOf(".") + 1);
            IModelElement validRoot = FQNListPropertyDescriptor.this.iElement.getModelSpace().getModelManager().getElementByName(validFQN);
            if (validRoot != null) {
                ArrayList<FQNContentProposal> r = new ArrayList<FQNContentProposal>();
                for (IModelElement e : validRoot.getElementsInNamespace()) {
                    if (!e.getName().startsWith(remainder)) continue;
                    r.add(new FQNContentProposal(e, position - begin));
                }
                return r.toArray(new IContentProposal[0]);
            }
            return null;
        }
    }
}

