/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.providers;

import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.providers.ViatraRootProvider;
import org.eclipse.viatra2.treeeditor.providers.ViatraTreeviewNotificationHandler;

public class ViatraContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private ViatraTreeviewNotificationHandler iNotificationHandler;
    private ViatraTreeEditor iVTE;
    private ViatraRootProvider iVRP;

    public ViatraContentProvider(TreeViewer tv, ViatraTreeEditor vte) {
        this.iVTE = vte;
        this.iNotificationHandler = new ViatraTreeviewNotificationHandler(tv, this);
        this.iVTE.getFramework().getTopmodel().getNotificationManager().addAllListener((ICoreNotificationListener)this.iNotificationHandler);
    }

    public void setDirty() {
        this.iVTE.setDirty();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IModelElement || inputElement instanceof ViatraRootProvider) {
            return this.getChildren(inputElement);
        }
        return null;
    }

    public void dispose() {
        this.iVTE.getFramework().getTopmodel().getNotificationManager().removeAllListener((ICoreNotificationListener)this.iNotificationHandler);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ViatraRootProvider) {
            this.iVRP = (ViatraRootProvider)newInput;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ViatraRootProvider) {
            IEntity ent = ((ViatraRootProvider)parentElement).getRootEntity();
            return new Object[]{ent};
        }
        Collection children = ((IModelElement)parentElement).getElementsInNamespace();
        String showTargets = this.iVTE.getFramework().getProperties().getRuntimeProperty("VIATRA2 Tree Editor", "Show 'to' relations at targets");
        if ("true".equalsIgnoreCase(showTargets)) {
            for (IRelation r : ((IModelElement)parentElement).getRelationsTo()) {
                children.add(new TargetRelationDummy(r));
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof IEntity) {
            if (((IEntity)element).getParent() == null) {
                return this.iVRP;
            }
            return ((IEntity)element).getParent();
        }
        if (element instanceof IRelation) {
            return ((IRelation)element).getFrom();
        }
        if (element instanceof TargetRelationDummy) {
            return ((TargetRelationDummy)element).rel.getTo();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ViatraRootProvider) {
            return true;
        }
        if (element instanceof IModelElement && !((IModelElement)element).getElementsInNamespace().isEmpty()) {
            return true;
        }
        String showTargets = this.iVTE.getFramework().getProperties().getRuntimeProperty("VIATRA2 Tree Editor", "Show 'to' relations at targets");
        return "true".equalsIgnoreCase(showTargets) && element instanceof IModelElement && !((IModelElement)element).getRelationsTo().isEmpty();
    }

    protected void addNotificationHandler(IModelElement me) {
        if (!me.getModelSpace().getNotificationManager().getNotificationListeners(me).contains(this.iNotificationHandler)) {
            me.getModelSpace().getNotificationManager().addNotificationListener(me, (ICoreNotificationListener)this.iNotificationHandler);
        }
    }

    protected void removeNotificationHandler(IModelElement me) {
        if (me.getModelSpace().getNotificationManager().getNotificationListeners(me).contains(this.iNotificationHandler)) {
            me.getModelSpace().getNotificationManager().removeNotificationListener(me, (ICoreNotificationListener)this.iNotificationHandler);
        }
    }

    public class TargetRelationDummy {
        public IRelation rel;

        public TargetRelationDummy(IRelation r) {
            this.rel = r;
        }
    }
}

