/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.providers;

import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.commands.ChangeElementNameCommand;

public class ViatraTreeEventListener
implements ModifyListener,
FocusListener,
KeyListener {
    protected TreeEditor iEditor;
    protected IModelElement iME;
    protected ViatraTreeEditor iVTE;

    public ViatraTreeEventListener(IModelElement me, TreeEditor te, ViatraTreeEditor vte) {
        this.iEditor = te;
        this.iME = me;
        this.iVTE = vte;
    }

    public void modifyText(ModifyEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.cancelEditing();
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 27) {
            this.cancelEditing();
        } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
            this.submitEditing();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void cancelEditing() {
        Control ctrl = this.iEditor.getEditor();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.removeFocusListener((FocusListener)this);
            ctrl.removeKeyListener((KeyListener)this);
            ((Text)ctrl).removeModifyListener((ModifyListener)this);
            ctrl.dispose();
        }
        this.iEditor.dispose();
    }

    public void submitEditing() {
        ChangeElementNameCommand cmd = new ChangeElementNameCommand();
        cmd.setTargetElem(this.iME);
        cmd.setNewElemName(((Text)this.iEditor.getEditor()).getText());
        this.iVTE.getCommandStack().execute(cmd);
        this.cancelEditing();
    }
}

