/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.providers;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectMoveTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetName;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationFrom;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetValue;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetViewInfo;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectTransactionBegin;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUndoableTransactionBegin;
import org.eclipse.viatra2.treeeditor.providers.ViatraContentProvider;

public class ViatraTreeviewNotificationHandler
implements ICoreNotificationListener {
    private TreeViewer iTreeViewer;
    private ViatraContentProvider iContentProvider;
    private boolean inTransaction = false;
    private boolean signalDirty = false;

    public ViatraTreeviewNotificationHandler(TreeViewer tv, ViatraContentProvider cp) {
        this.iTreeViewer = tv;
        this.iContentProvider = cp;
    }

    private void refreshTreeViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ViatraTreeviewNotificationHandler.this.iTreeViewer.refresh();
            }
        });
    }

    public void actionPerformed(final ICoreNotificationObject notification) {
        if (notification.getActionType().equals("begin transaction")) {
            Object info = ((NotificationObjectTransactionBegin)notification).getInfo();
            if (info instanceof Boolean && ((Boolean)info).booleanValue()) {
                this.inTransaction = true;
            }
            return;
        }
        if (notification.getActionType().equals("begin undoable transaction")) {
            Object info = ((NotificationObjectUndoableTransactionBegin)notification).getInfo();
            if (info instanceof Boolean && ((Boolean)info).booleanValue()) {
                this.inTransaction = true;
            }
            return;
        }
        if (notification.getActionType().equals("begin undo")) {
            this.inTransaction = true;
            return;
        }
        if (notification.getActionType().equals("end transaction")) {
            this.inTransaction = false;
            this.refreshTreeViewer();
            if (this.signalDirty) {
                this.iContentProvider.setDirty();
                this.signalDirty = false;
            }
            return;
        }
        if (notification.getActionType().equals("end undo")) {
            this.inTransaction = false;
            this.refreshTreeViewer();
            if (this.signalDirty) {
                this.iContentProvider.setDirty();
                this.signalDirty = false;
            }
            return;
        }
        if (this.inTransaction) {
            this.signalDirty = true;
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ViatraTreeviewNotificationHandler.this.handleNotification(notification);
            }
        });
    }

    private void handleNotification(ICoreNotificationObject notification) {
        if (notification.getActionType().equals("set name")) {
            ICoreNotificationObjectSetName n = (ICoreNotificationObjectSetName)notification;
            this.iTreeViewer.update((Object)n.getElement(), null);
            for (IModelElement inst_elem : n.getElement().getInstances()) {
                this.iTreeViewer.update((Object)inst_elem, null);
            }
            for (IModelElement st_elem : n.getElement().getSubtypes()) {
                this.iTreeViewer.update((Object)st_elem, null);
            }
            for (IRelation trg_rel : n.getElement().getRelationsTo()) {
                this.iTreeViewer.update((Object)trg_rel, null);
            }
        } else if (notification.getActionType().equals("set value")) {
            ICoreNotificationObjectSetValue n = (ICoreNotificationObjectSetValue)notification;
            this.iTreeViewer.update((Object)n.getEntity(), new String[]{"name"});
        } else if (notification.getActionType().equals("create instanceof")) {
            ICoreNotificationObjectCreateInstanceOf n = (ICoreNotificationObjectCreateInstanceOf)notification;
            this.iTreeViewer.update((Object)n.getInstance(), new String[]{"name"});
        } else if (notification.getActionType().equals("delete instanceof")) {
            ICoreNotificationObjectDeleteInstanceOf n = (ICoreNotificationObjectDeleteInstanceOf)notification;
            this.iTreeViewer.update((Object)n.getInstance(), new String[]{"name"});
        } else if (notification.getActionType().equals("create supertypeof")) {
            ICoreNotificationObjectCreateSupertypeOf n = (ICoreNotificationObjectCreateSupertypeOf)notification;
            this.iTreeViewer.update((Object)n.getSub(), new String[]{"name"});
        } else if (notification.getActionType().equals("delete supertypeof")) {
            ICoreNotificationObjectDeleteSupertypeOf n = (ICoreNotificationObjectDeleteSupertypeOf)notification;
            this.iTreeViewer.update((Object)n.getSub(), new String[]{"name"});
        } else if (notification.getActionType().equals("set view info")) {
            ICoreNotificationObjectSetViewInfo n = (ICoreNotificationObjectSetViewInfo)notification;
            this.iTreeViewer.update((Object)n.getElement(), new String[]{"name"});
        } else if (notification.getActionType().equals("create entity")) {
            ICoreNotificationObjectCreateEntity n = (ICoreNotificationObjectCreateEntity)notification;
            this.iTreeViewer.add((Object)n.getContainer(), (Object)n.getCreated());
        } else if (notification.getActionType().equals("create relation")) {
            ICoreNotificationObjectCreateRelation n = (ICoreNotificationObjectCreateRelation)notification;
            this.iTreeViewer.add((Object)n.getFrom(), (Object)n.getNewRelation());
        } else if (notification.getActionType().equals("move element to")) {
            ICoreNotificationObjectMoveTo n = (ICoreNotificationObjectMoveTo)notification;
            this.iTreeViewer.remove((Object)n.getElement());
            this.iTreeViewer.add((Object)n.getNewContainer(), (Object)n.getElement());
        } else if (notification.getActionType().equals("delete entity")) {
            ICoreNotificationObjectDeleteEntity n = (ICoreNotificationObjectDeleteEntity)notification;
            this.iTreeViewer.remove((Object)n.getDeleted());
        } else if (notification.getActionType().equals("delete relation")) {
            ICoreNotificationObjectDeleteRelation n = (ICoreNotificationObjectDeleteRelation)notification;
            this.iTreeViewer.remove((Object)n.getDeleted());
        } else if (!notification.getActionType().equals("delete containment")) {
            if (notification.getActionType().equals("set relation from")) {
                ICoreNotificationObjectSetRelationFrom n = (ICoreNotificationObjectSetRelationFrom)notification;
                this.iTreeViewer.remove((Object)n.getRelation());
                this.iTreeViewer.add((Object)n.getNewFrom(), (Object)n.getRelation());
            } else if (notification.getActionType().equals("set relation to")) {
                ICoreNotificationObjectSetRelationTo n = (ICoreNotificationObjectSetRelationTo)notification;
                this.iTreeViewer.update((Object)n.getRelation(), new String[]{"name"});
            }
        }
        this.iContentProvider.setDirty();
    }

    public int getListenerCategory() {
        return 0;
    }
}

