/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.executionEnvironment;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.ASMFunctionContent;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.machine.ASMInterpreterException;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ASMFunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.FunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionEnvironment
implements IExecutionEnvironment {
    protected IExecutionEnvironment parentExecutionEnvironment;
    protected IFramework framework;
    protected Map<Variable, Object> variableValues;
    protected ASMFunctionContent ASMFunctionValues;

    public IFramework getFramework() {
        return this.framework;
    }

    public void onBegin(Map<Variable, Object> variables) {
    }

    public Map<Variable, Object> onTerminate() {
        return null;
    }

    public ExecutionEnvironment(IFramework framework) {
        this.parentExecutionEnvironment = null;
        this.variableValues = new TreeMap<Variable, Object>(new Comparator<Variable>(){

            @Override
            public int compare(Variable o1, Variable o2) {
                int h_o2;
                int h_o1 = o1.hashCode();
                if (h_o1 == (h_o2 = o2.hashCode())) {
                    return 0;
                }
                if (h_o1 > h_o2) {
                    return 1;
                }
                return -1;
            }
        });
        this.ASMFunctionValues = ASMFunctionContent.getInstance();
        this.framework = framework;
    }

    public ExecutionEnvironment(IExecutionEnvironment parent) {
        this.parentExecutionEnvironment = parent;
        this.variableValues = new Hashtable<Variable, Object>(parent.getVariableValues());
        this.ASMFunctionValues = ASMFunctionContent.getInstance();
        this.framework = parent.getFramework();
    }

    public Object getValueOfASMFunction(ASMFunction asmFunction, EList<Object> location) {
        HashMap af = (HashMap)ASMFunctionContent.getInstance().get((Object)asmFunction);
        if (af == null) {
            return null;
        }
        return af.get(location);
    }

    public void updateASMFunction(ASMFunction asmFunction, EList<Object> location, Object value) throws ViatraTransformationException {
        if (this.ASMFunctionValues.get((Object)asmFunction) == null) {
            String[] context = new String[]{asmFunction.getName()};
            throw new ASMInterpreterException("Trying to update the {1} non-existent ASMFunction", context, (AnnotatedElement)asmFunction);
        }
        ((HashMap)this.ASMFunctionValues.get((Object)asmFunction)).put(location, value);
        this.ASMFunctionValues.notifyListeners(asmFunction, location, value);
    }

    public void addVariable(Variable key, Object value) throws ViatraTransformationException {
        if (this.variableValues.containsKey(key)) {
            String[] context = new String[]{key.getName()};
            throw new ASMInterpreterException("Tried to add the {1} variable twice to the execution environment.", context, (AnnotatedElement)key);
        }
        this.variableValues.put(key, value);
    }

    public void updateVariables(Map<Variable, Object> changedVariables) {
        this.variableValues.putAll(changedVariables);
    }

    public Object getVariableValue(Variable variable) throws ViatraTransformationException {
        if (this.variableValues.containsKey(variable)) {
            return this.variableValues.get(variable);
        }
        String[] context = new String[]{variable.getName()};
        throw new ASMInterpreterException("Tried to get the value of the {1} variable that has not been declared in the execution environment.", context, null);
    }

    public void setVariableValue(Variable variable, Object value) throws ViatraTransformationException {
        if (!this.variableValues.containsKey(variable)) {
            String[] context = new String[]{variable.getName()};
            throw new ASMInterpreterException("Tried to set the vallue of the {1} non-existent variable. ", context, null);
        }
        this.variableValues.put(variable, value);
    }

    public Map<Variable, Object> getVariableValues() {
        return this.variableValues;
    }

    public void fetchVariableVariations(HashMap<Variable, Vector<Object>> possibleVariableValues, Term termToBeEvaluated) {
        block6: {
            Set<Variable> variables = possibleVariableValues.keySet();
            if (!(termToBeEvaluated instanceof FunctionInvocation)) break block6;
            if (termToBeEvaluated instanceof ASMFunctionInvocation) {
                ((ASMFunctionInvocation)termToBeEvaluated).getActualParameters();
                for (Object parameter : ((ASMFunctionInvocation)termToBeEvaluated).getActualParameters()) {
                    if (parameter instanceof VariableReference) {
                        if (!variables.contains(((VariableReference)parameter).getVariable())) continue;
                        Integer index = ((ASMFunctionInvocation)termToBeEvaluated).getActualParameters().indexOf(parameter);
                        Set keys = ((HashMap)this.ASMFunctionValues.get((Object)((ASMFunctionInvocation)termToBeEvaluated).getCalledFunction())).keySet();
                        for (EList key : keys) {
                            if (possibleVariableValues.get(((VariableReference)parameter).getVariable()).contains(key.get(index.intValue()))) continue;
                            possibleVariableValues.get(((VariableReference)parameter).getVariable()).add(key.get(index.intValue()));
                        }
                        continue;
                    }
                    if (!(parameter instanceof FunctionInvocation)) continue;
                    this.fetchVariableVariations(possibleVariableValues, (Term)parameter);
                }
            } else {
                for (Object parameter : ((FunctionInvocation)termToBeEvaluated).getActualParameters()) {
                    this.fetchVariableVariations(possibleVariableValues, (Term)parameter);
                }
            }
        }
    }
}

