/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.machine;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.codegen.CodeOutputPlugin;
import org.eclipse.viatra2.errors.VPMRuntimeControlledException;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.ASMFunctionContent;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.executionEnvironment.ExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.machine.ASMInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.PatternMatcherProvider;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.InitialValue;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.interpreters.IProgressReport;
import org.eclipse.viatra2.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MachineInterpreter {
    protected Machine machine;
    protected IFramework frame;
    protected IExecutionEnvironment mainExecutionEnvironment;
    Logger log;
    CodeOutputPlugin codeout;

    public MachineInterpreter(IFramework f, Machine m) {
        Scope.DEFAULT_PARENT = f.getTopmodel().getModelManager().getRoot();
        this.frame = f;
        this.machine = m;
        this.log = this.frame.getLogger();
        this.codeout = this.frame.getCodeOutput();
        this.mainExecutionEnvironment = new ExecutionEnvironment(f);
        this.log.debug("GTASM Interpreter initialized.");
    }

    private void initASMFunctions(Machine input_machine) throws VPMRuntimeException {
        EList machines = input_machine.getModule().getMachine();
        for (Object obj : machines) {
            Machine m = (Machine)obj;
            for (Object o : m.getAsmFunctionDefinitions()) {
                ASMFunction fun = (ASMFunction)o;
                HashMap<BasicEList, Object> map = new HashMap<BasicEList, Object>();
                for (Object o2 : fun.getInitialValues()) {
                    InitialValue initialValue = (InitialValue)o2;
                    try {
                        BasicEList locationsList = new BasicEList();
                        for (Object o3 : initialValue.getLocations()) {
                            Term locationsTerm = (Term)o3;
                            locationsList.add(TermEvaluator.getInstance().evaluate(this.mainExecutionEnvironment, locationsTerm));
                        }
                        map.put(locationsList, TermEvaluator.getInstance().evaluate(this.mainExecutionEnvironment, initialValue.getValue()));
                    }
                    catch (ViatraTransformationException e) {
                        VPMRuntimeException eNew = new VPMRuntimeException("Initialization of ASMFunctions failed: " + e.getMessage());
                        throw eNew;
                    }
                }
                ASMFunctionContent.getInstance().put((Object)fun, map);
            }
        }
    }

    private void initAllASMFunctions() throws VPMRuntimeException {
        for (Object obj : this.frame.getMachines()) {
            if (!(obj instanceof Machine)) continue;
            this.initASMFunctions((Machine)obj);
        }
    }

    public void initPatternMatcher() throws VPMRuntimeException {
        EList rtAnnotations = this.machine.getRuntimeAnnotations();
        if (rtAnnotations != null && rtAnnotations.size() > 0) {
            for (Object obj : rtAnnotations) {
                RuntimeAnnotation an = null;
                if (!(obj instanceof RuntimeAnnotation)) {
                    throw new VPMRuntimeException("[INTERNAL ERROR] Illegal Annoation for the rule could not be cast to RunTimeAnnotation: {1}");
                }
                an = (RuntimeAnnotation)obj;
                if ("@incremental".equals(an.getAnnotationName().toLowerCase())) {
                    PatternMatcherProvider.setPatternMatcherIDToUse((String)"org.eclipse.viatra2.patternmatcher.incremental_rete");
                    PatternMatcherProvider.setGTRuleMathcerIDToUse((String)"org.eclipse.viatra2.gtmatcher.alternative");
                    continue;
                }
                if (!"@localsearch".equals(an.getAnnotationName().toLowerCase())) continue;
                PatternMatcherProvider.setPatternMatcherIDToUse((String)"org.eclipse.viatra2.patternmatcher.local_search");
                PatternMatcherProvider.setGTRuleMathcerIDToUse((String)"org.eclipse.viatra2.gtmatcher.local_search");
            }
        }
    }

    public void operate(Map<String, Object> parameters, IProgressReport pr, Rule entryPoint) throws VPMRuntimeException {
        this.log.debug("GTASM execution started");
        try {
            try {
                this.initInterpreters();
                this.initAllASMFunctions();
                this.initPatternMatcher();
                this.codeout.beginWork();
                try {
                    for (Object localVariable : entryPoint.getLocalVariables()) {
                        if (parameters.containsKey(((Variable)localVariable).getName())) {
                            this.mainExecutionEnvironment.addVariable((Variable)localVariable, parameters.get(((Variable)localVariable).getName()));
                            continue;
                        }
                        this.mainExecutionEnvironment.addVariable((Variable)localVariable, (Object)ValueKind.UNDEF_LITERAL);
                    }
                }
                catch (ViatraTransformationException e) {
                    String[] context = new String[]{entryPoint.getFqn()};
                    throw new ASMInterpreterException("Error initializing the parameters of the {1} entrypoint rule:" + e.getMessage(), context, (AnnotatedElement)entryPoint);
                }
                RuleInterpreter.getInstance().interpretRule(this.mainExecutionEnvironment, entryPoint, pr);
                this.clearASMFunctions();
                this.log.debug("GTASM execution finished.");
            }
            catch (ViatraTransformationException e) {
                this.log.message(1, e.getMessage(), (Throwable)e);
                throw new VPMRuntimeControlledException("The transformation encountered an error: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            PatternMatcherProvider.resetPatternMatcher();
            this.codeout.endWork();
        }
    }

    private void clearASMFunctions() {
        ASMFunctionContent.getInstance().clear();
    }

    public void initInterpreters() {
        RuleInterpreter.initInterpreters(this.log, this.codeout);
    }
}

