/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.executionEnvironment.BlockRuleExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.machine.ASMInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.ExecutionMode;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternMatcherParameters;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IGTRuleMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.PatternMatcherProvider;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.BlockRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.ChooseRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.CollectionIteratorRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.ForallRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.LetRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotationElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.SymbolicRuleParameter;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.VariableDefinition;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.DirectionKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ASMRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.GTRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.ContainmentConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;
import org.eclipse.viatra2.interpreters.IProgressReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockRuleInterpreter
extends RuleInterpreter {
    private static BlockRuleInterpreter _instance = new BlockRuleInterpreter();

    private BlockRuleInterpreter() {
    }

    public static BlockRuleInterpreter getInstance() {
        return _instance;
    }

    @Override
    public Boolean interpretRule(IExecutionEnvironment executionEnvironment, ASMRuleInvocation ruleToBeInterpreted, IProgressReport pr) throws ViatraTransformationException {
        BlockRule blockRule = (BlockRule)ruleToBeInterpreted;
        if (blockRule instanceof LetRule) {
            LetRule letBlockRule = (LetRule)ruleToBeInterpreted;
            return this.interpretLetRule(executionEnvironment, letBlockRule, pr);
        }
        if (blockRule instanceof ForallRule) {
            ForallRule forallBlockRule = (ForallRule)blockRule;
            if (forallBlockRule.getGtrule() == null) {
                if (forallBlockRule.getCondition() instanceof GTPatternCall) {
                    GTPatternCall patternCall = (GTPatternCall)forallBlockRule.getCondition();
                    for (Object _ra : patternCall.getCalledPattern().getRuntimeAnnotations()) {
                        RuntimeAnnotation ra = (RuntimeAnnotation)_ra;
                        if (!ra.getAnnotationName().equalsIgnoreCase("@parallelforall")) continue;
                        for (Object _p : ra.getElements()) {
                            RuntimeAnnotationElement p = (RuntimeAnnotationElement)_p;
                            if (!p.getKey().equalsIgnoreCase("threadpoolsize")) continue;
                            Integer.parseInt(p.getValue());
                        }
                    }
                    return this.interpretForallRulewithGTPattern(executionEnvironment, forallBlockRule, pr);
                }
                return this.interpretForallRulewithASMFunction(executionEnvironment, forallBlockRule, pr);
            }
            return this.interpretForallRulewithGTRule(executionEnvironment, forallBlockRule, pr);
        }
        if (blockRule instanceof ChooseRule) {
            ChooseRule chooseBlockRule = (ChooseRule)blockRule;
            if (chooseBlockRule.getGtrule() == null) {
                if (chooseBlockRule.getCondition() instanceof GTPatternCall) {
                    return this.interpretChooseRulewithGTPattern(executionEnvironment, chooseBlockRule, pr);
                }
                return this.interpretChooseRulewithASMFunction(executionEnvironment, chooseBlockRule, pr);
            }
            return this.interpretChooseRulewithGTRule(executionEnvironment, chooseBlockRule, pr);
        }
        return Boolean.FALSE;
    }

    private Boolean interpretLetRule(IExecutionEnvironment executionEnvironment, LetRule letBlockRule, IProgressReport pr) throws ViatraTransformationException {
        BlockRuleExecutionEnvironment letRuleExecutionEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework(), letBlockRule.getBody());
        Hashtable childExecutionEnvironmentVariables = new Hashtable();
        childExecutionEnvironmentVariables.putAll(executionEnvironment.getVariableValues());
        for (Object variableDefinition : letBlockRule.getDefinitions()) {
            VariableDefinition varDef = (VariableDefinition)variableDefinition;
            childExecutionEnvironmentVariables.put(varDef.getVariable(), varDef.getValue() == null ? ValueKind.UNDEF_LITERAL : TermEvaluator.getInstance().evaluate(executionEnvironment, varDef.getValue()));
        }
        letRuleExecutionEnvironment.onBegin(childExecutionEnvironmentVariables);
        Boolean result = RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)letRuleExecutionEnvironment, letBlockRule.getBody(), pr);
        childExecutionEnvironmentVariables = (Hashtable)letRuleExecutionEnvironment.onTerminate();
        for (Variable variable : executionEnvironment.getVariableValues().keySet()) {
            try {
                executionEnvironment.setVariableValue(variable, childExecutionEnvironmentVariables.get(variable));
            }
            catch (ViatraTransformationException e) {
                String[] context = new String[]{variable.getName(), e.getMessage()};
                throw new ASMInterpreterException("Error at setting the value of the {1} variable after returning from the {2} native ASM rule call: {3}", context, (AnnotatedElement)letBlockRule);
            }
        }
        return result;
    }

    private Boolean interpretForallRulewithGTRule(IExecutionEnvironment executionEnvironment, ForallRule forallBlockRule, IProgressReport pr) throws ViatraTransformationException {
        Collection<IMatching> lHSmatches;
        IGTRuleMatcher gtMatcher;
        HashMap<Variable, Scope> parameterParameterScopes = new HashMap();
        GTRule gtRule = forallBlockRule.getGtrule().getRule();
        BlockRuleExecutionEnvironment forallRuleExecutionEnvironment = this.getNewExecutionEnvironment(executionEnvironment, (CollectionIteratorRule)forallBlockRule);
        BlockRuleExecutionEnvironment gtEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework());
        parameterParameterScopes = this.getScopesFromContainmentConstraints(forallRuleExecutionEnvironment, (CollectionIteratorRule)forallBlockRule);
        PatternMatcherParameters mp = this.getGTRuleMatchParameters(forallRuleExecutionEnvironment, (CollectionIteratorRule)forallBlockRule, parameterParameterScopes, gtRule, forallBlockRule.getGtrule());
        try {
            gtMatcher = PatternMatcherProvider.getInstance().getGtRuleMatcher((IExecutionEnvironment)gtEnvironment, gtRule, mp);
            lHSmatches = gtMatcher.initMatchAll(mp.getCallSignature(), mp.getInputMapping(), mp.getQuantificationOrder());
        }
        catch (ViatraTransformationException e1) {
            throw e1.addNewStackElement((EObject)forallBlockRule);
        }
        if (lHSmatches != null && lHSmatches.size() != 0) {
            lHSmatches = this.reorder(gtRule.getPrecondition().getCalledPattern(), lHSmatches);
            for (IMatching lHSMatch : lHSmatches) {
                Object[] match;
                try {
                    match = gtMatcher.matchAll(lHSMatch, mp.getCallSignature(), mp.getInputMapping());
                }
                catch (ViatraTransformationException e1) {
                    throw e1.addNewStackElement((EObject)forallBlockRule);
                }
                this.evaulateDoPartofGTRuleInvocation(gtRule, match, (BlockRule)forallBlockRule, forallRuleExecutionEnvironment, forallBlockRule.getGtrule(), pr);
            }
        }
        forallRuleExecutionEnvironment.onTerminate();
        for (Variable var : executionEnvironment.getVariableValues().keySet()) {
            executionEnvironment.setVariableValue(var, forallRuleExecutionEnvironment.getVariableValue(var));
        }
        return Boolean.TRUE;
    }

    private Boolean interpretForallRulewithASMFunction(IExecutionEnvironment executionEnvironment, ForallRule forallBlockRule, IProgressReport pr) throws ViatraTransformationException {
        HashMap valueList = new HashMap();
        Hashtable<Variable, Object> variables = new Hashtable<Variable, Object>(executionEnvironment.getVariableValues());
        for (Object variable : forallBlockRule.getLocalVariables()) {
            valueList.put((Variable)variable, new Vector());
            variables.put((Variable)variable, ValueKind.UNDEF_LITERAL);
        }
        executionEnvironment.fetchVariableVariations(valueList, forallBlockRule.getCondition());
        Object[] keys = valueList.keySet().toArray();
        BlockRuleExecutionEnvironment forallRuleExecutionEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework(), forallBlockRule.getBody());
        forallRuleExecutionEnvironment.onBegin(variables);
        Vector<Integer> divVect = new Vector<Integer>();
        divVect.add(new Integer(((Vector)valueList.get(keys[0])).size()));
        Integer maxCount = new Integer(((Vector)valueList.get(keys[0])).size());
        int iter = 1;
        while (iter < valueList.size()) {
            maxCount = maxCount * ((Vector)valueList.get(keys[iter])).size();
            divVect.add(((Vector)valueList.get(keys[iter])).size());
            if (((Vector)valueList.get(keys[iter])).size() == 0) {
                return Boolean.FALSE;
            }
            ++iter;
        }
        Integer size = divVect.size();
        Integer iter_config = 0;
        while (iter_config < maxCount) {
            Integer config_no = new Integer(iter_config);
            int iter_var = 0;
            while (iter_var < size) {
                Variable variable = (Variable)valueList.keySet().toArray()[iter_var];
                try {
                    forallRuleExecutionEnvironment.setVariableValue(variable, ((Vector)valueList.get(valueList.keySet().toArray()[iter_var])).get(config_no % (Integer)divVect.get(iter_var)));
                }
                catch (ViatraTransformationException e) {
                    String[] context = new String[]{variable.getName(), e.getMessage()};
                    throw new ASMInterpreterException("Error at setting the initial value of the {1} variable: {2} ", context, (AnnotatedElement)forallBlockRule);
                }
                config_no = (config_no - config_no % (Integer)divVect.get(iter_var)) / (Integer)divVect.get(iter_var);
                ++iter_var;
            }
            if (Boolean.TRUE.equals(TermEvaluator.getInstance().evaluate((IExecutionEnvironment)forallRuleExecutionEnvironment, forallBlockRule.getCondition()))) {
                RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)forallRuleExecutionEnvironment, forallBlockRule.getBody(), pr);
            }
            iter_config = iter_config + 1;
        }
        forallRuleExecutionEnvironment.onTerminate();
        for (Variable var : executionEnvironment.getVariableValues().keySet()) {
            executionEnvironment.setVariableValue(var, forallRuleExecutionEnvironment.getVariableValue(var));
        }
        return Boolean.TRUE;
    }

    private Boolean interpretForallRulewithGTPattern(IExecutionEnvironment executionEnvironment, ForallRule forallBlockRule, IProgressReport pr) throws ViatraTransformationException {
        Collection<IMatching> matches;
        PatternMatcherParameters mp;
        int i = 0;
        GTPatternCall forallGTPatternCall = (GTPatternCall)forallBlockRule.getCondition();
        BlockRuleExecutionEnvironment forallRuleExecutionEnvironment = this.getNewExecutionEnvironment(executionEnvironment, (CollectionIteratorRule)forallBlockRule);
        HashMap<Variable, Scope> parameterParameterScopes = this.getScopesFromContainmentConstraints(forallRuleExecutionEnvironment, (CollectionIteratorRule)forallBlockRule);
        try {
            IPatternMatcher patternMatcher = PatternMatcherProvider.getInstance().getPatternMatcher((IExecutionEnvironment)forallRuleExecutionEnvironment, forallGTPatternCall.getCalledPattern());
            mp = this.getMatchParameters(forallRuleExecutionEnvironment, (CollectionIteratorRule)forallBlockRule, parameterParameterScopes);
            matches = patternMatcher.matchAll(mp.getInputMapping(), mp.getCallSignature(), mp.getQuantificationOrder());
        }
        catch (ViatraTransformationException e1) {
            throw e1.addNewStackElement((EObject)forallBlockRule);
        }
        matches = this.reorder(forallGTPatternCall.getCalledPattern(), matches);
        for (IMatching match : matches) {
            i = 0;
            while (i < forallGTPatternCall.getActualParameters().size()) {
                if (mp.getCallSignature()[i].getParameterMode().equals((Object)ParameterMode.OUTPUT)) {
                    Variable variable = ((VariableReference)forallGTPatternCall.getActualParameters().get(i)).getVariable();
                    try {
                        forallRuleExecutionEnvironment.setVariableValue(variable, match.lookup(i));
                    }
                    catch (ViatraTransformationException e) {
                        String[] context = new String[]{variable.getName(), e.getMessage()};
                        throw new ASMInterpreterException("Error at setting the initial value of the {1} variable in the forall execution context: {2} ", context, (AnnotatedElement)forallBlockRule);
                    }
                }
                ++i;
            }
            RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)forallRuleExecutionEnvironment, forallBlockRule.getBody(), pr);
        }
        forallRuleExecutionEnvironment.onTerminate();
        for (Variable var : executionEnvironment.getVariableValues().keySet()) {
            executionEnvironment.setVariableValue(var, forallRuleExecutionEnvironment.getVariableValue(var));
        }
        return Boolean.TRUE;
    }

    private Boolean interpretChooseRulewithGTPattern(IExecutionEnvironment executionEnvironment, ChooseRule chooseBlockRule, IProgressReport pr) throws ViatraTransformationException {
        IMatching match;
        PatternMatcherParameters mp;
        int i = 0;
        GTPatternCall chooseGTPatternCall = (GTPatternCall)chooseBlockRule.getCondition();
        HashMap<Variable, Scope> parameterParameterScopes = new HashMap();
        BlockRuleExecutionEnvironment chooseRuleExecutionEnvironment = this.getNewExecutionEnvironment(executionEnvironment, (CollectionIteratorRule)chooseBlockRule);
        parameterParameterScopes = this.getScopesFromContainmentConstraints(chooseRuleExecutionEnvironment, (CollectionIteratorRule)chooseBlockRule);
        GTPattern gtPattern = chooseGTPatternCall.getCalledPattern();
        boolean isRandom = false;
        for (Object annot : gtPattern.getRuntimeAnnotations()) {
            if (!"@random".equals(((RuntimeAnnotation)annot).getAnnotationName().toLowerCase())) continue;
            isRandom = true;
            break;
        }
        try {
            IPatternMatcher patternMatcher = PatternMatcherProvider.getInstance().getPatternMatcher((IExecutionEnvironment)chooseRuleExecutionEnvironment, gtPattern);
            mp = this.getMatchParameters(chooseRuleExecutionEnvironment, (CollectionIteratorRule)chooseBlockRule, parameterParameterScopes);
            match = !isRandom ? patternMatcher.match(mp.getInputMapping(), mp.getCallSignature()) : patternMatcher.matchRandomly(mp.getInputMapping(), mp.getCallSignature());
        }
        catch (ViatraTransformationException e1) {
            throw e1.addNewStackElement((EObject)chooseBlockRule);
        }
        if (match == null) {
            return Boolean.FALSE;
        }
        i = 0;
        while (i < chooseGTPatternCall.getActualParameters().size()) {
            if (mp.getCallSignature()[i].getParameterMode().equals((Object)ParameterMode.OUTPUT)) {
                Variable variable = ((VariableReference)chooseGTPatternCall.getActualParameters().get(i)).getVariable();
                try {
                    chooseRuleExecutionEnvironment.setVariableValue(variable, match.lookup(i));
                }
                catch (ViatraTransformationException e) {
                    String[] context = new String[]{variable.getName(), e.getMessage()};
                    throw new ASMInterpreterException("Error at setting the initial value of the {1} variable in the choose execution context: {2} ", context, (AnnotatedElement)chooseBlockRule);
                }
            }
            ++i;
        }
        Boolean result = RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)chooseRuleExecutionEnvironment, chooseBlockRule.getBody(), pr);
        chooseRuleExecutionEnvironment.onTerminate();
        for (Variable var : executionEnvironment.getVariableValues().keySet()) {
            executionEnvironment.setVariableValue(var, chooseRuleExecutionEnvironment.getVariableValue(var));
        }
        return result;
    }

    private Boolean interpretChooseRulewithASMFunction(IExecutionEnvironment executionEnvironment, ChooseRule chooseBlockRule, IProgressReport pr) throws ViatraTransformationException {
        HashMap valueList = new HashMap();
        Hashtable<Variable, Object> variables = new Hashtable<Variable, Object>(executionEnvironment.getVariableValues());
        for (Object variable : chooseBlockRule.getLocalVariables()) {
            valueList.put((Variable)variable, new Vector());
            variables.put((Variable)variable, ValueKind.UNDEF_LITERAL);
        }
        executionEnvironment.fetchVariableVariations(valueList, chooseBlockRule.getCondition());
        Object[] keys = valueList.keySet().toArray();
        BlockRuleExecutionEnvironment chooseRuleExecutionEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework(), chooseBlockRule.getBody());
        chooseRuleExecutionEnvironment.onBegin(variables);
        Vector<Integer> divVect = new Vector<Integer>();
        divVect.add(new Integer(((Vector)valueList.get(keys[0])).size()));
        Integer maxCount = new Integer(((Vector)valueList.get(keys[0])).size());
        int iter = 1;
        while (iter < valueList.size()) {
            maxCount = maxCount * ((Vector)valueList.get(keys[iter])).size();
            divVect.add(((Vector)valueList.get(keys[iter])).size());
            if (((Vector)valueList.get(keys[iter])).size() == 0) {
                return Boolean.FALSE;
            }
            ++iter;
        }
        Integer size = divVect.size();
        Integer iter_config = 0;
        while (iter_config < maxCount) {
            Integer config_no = new Integer(iter_config);
            int iter_var = 0;
            while (iter_var < size) {
                Variable variable = (Variable)valueList.keySet().toArray()[iter_var];
                try {
                    chooseRuleExecutionEnvironment.setVariableValue(variable, ((Vector)valueList.get(valueList.keySet().toArray()[iter_var])).get(config_no % (Integer)divVect.get(iter_var)));
                }
                catch (ViatraTransformationException e) {
                    String[] context = new String[]{variable.getName(), e.getMessage()};
                    throw new ASMInterpreterException("Error at setting the initial value of the {1} variable: {2} ", context, (AnnotatedElement)chooseBlockRule);
                }
                config_no = (config_no - config_no % (Integer)divVect.get(iter_var)) / (Integer)divVect.get(iter_var);
                ++iter_var;
            }
            if (Boolean.TRUE.equals(TermEvaluator.getInstance().evaluate((IExecutionEnvironment)chooseRuleExecutionEnvironment, chooseBlockRule.getCondition()))) {
                return RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)chooseRuleExecutionEnvironment, chooseBlockRule.getBody(), pr);
            }
            chooseRuleExecutionEnvironment.onTerminate();
            for (Variable var : executionEnvironment.getVariableValues().keySet()) {
                executionEnvironment.setVariableValue(var, chooseRuleExecutionEnvironment.getVariableValue(var));
            }
            iter_config = iter_config + 1;
        }
        return Boolean.FALSE;
    }

    private Boolean interpretChooseRulewithGTRule(IExecutionEnvironment executionEnvironment, ChooseRule chooseBlockRule, IProgressReport pr) throws ViatraTransformationException {
        Object[] match;
        HashMap<Variable, Scope> parameterParameterScopes = new HashMap();
        GTRule gtRule = chooseBlockRule.getGtrule().getRule();
        BlockRuleExecutionEnvironment chooseRuleExecutionEnvironment = this.getNewExecutionEnvironment(executionEnvironment, (CollectionIteratorRule)chooseBlockRule);
        BlockRuleExecutionEnvironment gtEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework());
        parameterParameterScopes = this.getScopesFromContainmentConstraints(chooseRuleExecutionEnvironment, (CollectionIteratorRule)chooseBlockRule);
        PatternMatcherParameters mp = this.getGTRuleMatchParameters(chooseRuleExecutionEnvironment, (CollectionIteratorRule)chooseBlockRule, parameterParameterScopes, gtRule, chooseBlockRule.getGtrule());
        try {
            IGTRuleMatcher gtMatcher = PatternMatcherProvider.getInstance().getGtRuleMatcher((IExecutionEnvironment)gtEnvironment, gtRule, mp);
            match = gtMatcher.match(mp.getCallSignature(), mp.getInputMapping());
        }
        catch (ViatraTransformationException e1) {
            throw e1.addNewStackElement((EObject)chooseBlockRule);
        }
        if (match != null) {
            Boolean result = this.evaulateDoPartofGTRuleInvocation(gtRule, match, (BlockRule)chooseBlockRule, chooseRuleExecutionEnvironment, chooseBlockRule.getGtrule(), pr);
            chooseRuleExecutionEnvironment.onTerminate();
            for (Variable var : executionEnvironment.getVariableValues().keySet()) {
                executionEnvironment.setVariableValue(var, chooseRuleExecutionEnvironment.getVariableValue(var));
            }
            return result;
        }
        return Boolean.FALSE;
    }

    private HashMap<Variable, Scope> getScopesFromContainmentConstraints(IExecutionEnvironment executionEnvironment, CollectionIteratorRule rule) throws ViatraTransformationException {
        EList containmentConstraints = rule.getContainmentConstraints();
        HashMap<Variable, Scope> parameterScopes = new HashMap<Variable, Scope>();
        for (Object cC : containmentConstraints) {
            ContainmentConstraint containmentConstraint = (ContainmentConstraint)cC;
            if (containmentConstraint.getParent() != null) {
                Object constraintParent = TermEvaluator.getInstance().evaluate(executionEnvironment, containmentConstraint.getParent());
                if (constraintParent instanceof IEntity) {
                    parameterScopes.put(containmentConstraint.getVariable(), new Scope(Integer.valueOf(containmentConstraint.getMode().getValue()), (IModelElement)TermEvaluator.getInstance().evaluate(executionEnvironment, containmentConstraint.getParent())));
                    continue;
                }
                String[] context = new String[]{containmentConstraint.getVariable().getName()};
                ASMInterpreterException e = new ASMInterpreterException("The {1} Scope is not an Entity", context, (AnnotatedElement)containmentConstraint.getVariable());
                throw e.addNewStackElement((EObject)rule);
            }
            parameterScopes.put(containmentConstraint.getVariable(), new Scope());
        }
        return parameterScopes;
    }

    private boolean evaulateDoPartofGTRuleInvocation(GTRule gtRule, Object[] match, BlockRule blockRule, IExecutionEnvironment blockRuleExecutionEnvironment, GTRuleInvocation ruleInvocation, IProgressReport pr) throws ViatraTransformationException {
        if (blockRule.getBody() == null) {
            return Boolean.TRUE;
        }
        GTRuleInvocation gtRuleInvocation = ((CollectionIteratorRule)blockRule).getGtrule();
        int i = 0;
        while (i < gtRule.getSymParameters().size()) {
            Object ActualTerm;
            if (!(((SymbolicRuleParameter)gtRule.getSymParameters().get(i)).getDirection().equals((Object)DirectionKind.IN_LITERAL) || !match[i].equals(ValueKind.UNDEF_LITERAL) || (ActualTerm = ruleInvocation.getActualParameters().get(i)) instanceof VariableReference && ((CollectionIteratorRule)blockRule).getLocalVariables().contains((Object)((VariableReference)ActualTerm).getVariable()))) {
                String[] context = new String[]{((SymbolicRuleParameter)gtRule.getSymParameters().get(i)).getName(), gtRule.getName()};
                throw new ASMInterpreterException("The {1} variable is not bound after the execution of the {2} gtrule", context, (AnnotatedElement)blockRule);
            }
            Variable variable = ((VariableReference)gtRuleInvocation.getActualParameters().get(i)).getVariable();
            try {
                if (gtRuleInvocation.getActualParameters().get(i) instanceof VariableReference) {
                    blockRuleExecutionEnvironment.setVariableValue(variable, match[i]);
                }
            }
            catch (ViatraTransformationException e) {
                String[] context = new String[]{variable.getName(), e.getMessage()};
                throw new ASMInterpreterException(blockRule instanceof ForallRule ? "Error at setting the initial value of the {1} variable in the forall execution context: {2} " : "Error at setting the initial value of the {1} variable in the choose execution context: {2} ", context, (AnnotatedElement)blockRule);
            }
            ++i;
        }
        return RuleInterpreter.getInstance().interpretRule(blockRuleExecutionEnvironment, blockRule.getBody(), pr);
    }

    private PatternMatcherParameters getGTRuleMatchParameters(IExecutionEnvironment executionEnvironment, CollectionIteratorRule ruleToBeInterpreted, Map<Variable, Scope> parameterScopes, GTRule gtRule, GTRuleInvocation invocation) throws ViatraTransformationException {
        Object[] patternParams = new Object[invocation.getActualParameters().size()];
        Integer[] quantificationOrder = new Integer[invocation.getActualParameters().size()];
        PatternCallSignature[] patternCallSignatures = new PatternCallSignature[invocation.getActualParameters().size()];
        int outerVariableCounterForQuantificationOrder = ruleToBeInterpreted.getLocalVariables().size();
        int localVariableCounterForQuantificationOrder = 0;
        int i = 0;
        while (i < invocation.getActualParameters().size()) {
            Object ActualTerm = invocation.getActualParameters().get(i);
            SymbolicRuleParameter symParam = (SymbolicRuleParameter)gtRule.getSymParameters().get(i);
            PatternCallSignature pcs = new PatternCallSignature();
            patternParams[i] = TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)ActualTerm);
            if (ActualTerm instanceof VariableReference && ruleToBeInterpreted.getLocalVariables().contains((Object)((VariableReference)ActualTerm).getVariable())) {
                if (ruleToBeInterpreted instanceof ForallRule) {
                    pcs.setExecutionMode(ExecutionMode.MULTIPLE_RESULTS);
                } else {
                    pcs.setExecutionMode(ExecutionMode.SINGLE_RESULT);
                }
                boolean isQuantifiedVariableinLHS = false;
                int j = 0;
                while (j < gtRule.getPrecondition().getActualParameters().size()) {
                    if (((VariableReference)gtRule.getPrecondition().getActualParameters().get(j)).getVariable().equals(symParam.getVariable())) {
                        isQuantifiedVariableinLHS = true;
                    }
                    ++j;
                }
                if (!isQuantifiedVariableinLHS) {
                    String[] context = new String[]{((VariableReference)ActualTerm).getVariable().getName(), gtRule.getName()};
                    ASMInterpreterException e = new ASMInterpreterException("The {1} variable is quantified but not used in the LHS of the {2} gtRule", context, (AnnotatedElement)gtRule);
                    throw e.addNewStackElement((EObject)ruleToBeInterpreted);
                }
            } else {
                pcs.setExecutionMode(ExecutionMode.SINGLE_RESULT);
            }
            if (symParam.getDirection().equals((Object)DirectionKind.IN_LITERAL)) {
                if (patternParams[i] == null || ValueKind.UNDEF_LITERAL.equals(patternParams[i])) {
                    String[] context = new String[]{symParam.getVariable().getName(), gtRule.getName()};
                    ASMInterpreterException e = new ASMInterpreterException("The value of the {1} variable can not be 'UNDEF' as it is an INPUT parameter for the {2} gtRule", context, (AnnotatedElement)gtRule);
                    throw e.addNewStackElement((EObject)ruleToBeInterpreted);
                }
                pcs.setParameterMode(ParameterMode.INPUT);
            } else if (symParam.getDirection().equals((Object)DirectionKind.OUT_LITERAL)) {
                pcs.setParameterMode(ParameterMode.OUTPUT);
                patternParams[i] = ValueKind.UNDEF_LITERAL;
            } else {
                if (patternParams[i] == null || ValueKind.UNDEF_LITERAL.equals(patternParams[i])) {
                    String[] context = new String[]{symParam.getVariable().getName(), gtRule.getName()};
                    ASMInterpreterException e = new ASMInterpreterException("The value of the {1} variable can not be 'UNDEF' as it is an INPUT parameter for the {2} gtRule", context, (AnnotatedElement)gtRule);
                    throw e.addNewStackElement((EObject)ruleToBeInterpreted);
                }
                pcs.setParameterMode(ParameterMode.INPUT);
            }
            if (ActualTerm instanceof VariableReference) {
                if (parameterScopes.containsKey(((VariableReference)ActualTerm).getVariable())) {
                    pcs.setParameterScope(parameterScopes.get(((VariableReference)ActualTerm).getVariable()));
                } else {
                    pcs.setParameterScope(new Scope());
                }
            } else {
                pcs.setParameterScope(new Scope());
            }
            if (ruleToBeInterpreted instanceof ForallRule) {
                if (ActualTerm instanceof VariableReference) {
                    if (ruleToBeInterpreted.getLocalVariables().indexOf((Object)((VariableReference)ActualTerm).getVariable()) == -1) {
                        if (invocation.getActualParameters().size() == outerVariableCounterForQuantificationOrder) {
                            this.getNoneUsedVariable(ruleToBeInterpreted);
                        }
                        quantificationOrder[outerVariableCounterForQuantificationOrder] = i;
                        ++outerVariableCounterForQuantificationOrder;
                    } else {
                        quantificationOrder[ruleToBeInterpreted.getLocalVariables().indexOf((Object)((VariableReference)ActualTerm).getVariable())] = i;
                        ++localVariableCounterForQuantificationOrder;
                    }
                } else {
                    if (invocation.getActualParameters().size() == outerVariableCounterForQuantificationOrder) {
                        this.getNoneUsedVariable(ruleToBeInterpreted);
                    }
                    quantificationOrder[outerVariableCounterForQuantificationOrder] = i;
                    ++outerVariableCounterForQuantificationOrder;
                }
            }
            patternCallSignatures[i] = pcs;
            ++i;
        }
        return new PatternMatcherParameters(patternCallSignatures, patternParams, quantificationOrder);
    }

    private void getNoneUsedVariable(CollectionIteratorRule ruleToBeInterpreted) throws ViatraTransformationException {
        String name = ruleToBeInterpreted.getCondition() instanceof GTPatternCall ? String.valueOf(((GTPatternCall)ruleToBeInterpreted.getCondition()).getCalledPattern().getName()) + " pattern" : String.valueOf(ruleToBeInterpreted.getGtrule().getRule().getName()) + " GT Rule";
        EList actualParamater = ruleToBeInterpreted.getCondition() instanceof GTPatternCall ? ((GTPatternCall)ruleToBeInterpreted.getCondition()).getActualParameters() : ruleToBeInterpreted.getGtrule().getActualParameters();
        int j = 0;
        while (j < ruleToBeInterpreted.getLocalVariables().size()) {
            Variable locVar = (Variable)ruleToBeInterpreted.getLocalVariables().get(j);
            boolean usedInRule = false;
            int k = 0;
            while (k < actualParamater.size()) {
                if (actualParamater.get(k) instanceof VariableReference && ((VariableReference)actualParamater.get(k)).getVariable().equals(locVar)) {
                    usedInRule = true;
                }
                ++k;
            }
            if (!usedInRule) {
                String[] context = new String[]{locVar.getName(), name};
                throw new ASMInterpreterException(" The {1} variable is quantified but not used in the {2}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            ++j;
        }
        String[] context = new String[]{name};
        throw new ASMInterpreterException("[INTERNAL ERROR] A FATAL error occured during the execution of the {1} rule.", context, (AnnotatedElement)ruleToBeInterpreted);
    }

    /*
     * Enabled aggressive block sorting
     */
    private PatternMatcherParameters getMatchParameters(IExecutionEnvironment executionEnvironment, CollectionIteratorRule ruleToBeInterpreted, Map<Variable, Scope> parameterScopes) throws ViatraTransformationException {
        CollectionIteratorRule iteratorBlockRule = ruleToBeInterpreted;
        int paramSize = ((GTPatternCall)iteratorBlockRule.getCondition()).getActualParameters().size();
        if (paramSize < iteratorBlockRule.getLocalVariables().size()) {
            this.getNoneUsedVariable(ruleToBeInterpreted);
        }
        Object[] patternParams = new Object[paramSize];
        Integer[] quantificationOrder = new Integer[paramSize];
        PatternCallSignature[] patternCallSignatures = new PatternCallSignature[paramSize];
        int outerVariableCounterForQuantificationOrder = iteratorBlockRule.getLocalVariables().size();
        int localVariableCounterForQuantificationOrder = 0;
        int i = 0;
        while (i < paramSize) {
            Variable variable;
            PatternCallSignature pcs;
            Object ActualTerm;
            block17: {
                ActualTerm = ((GTPatternCall)iteratorBlockRule.getCondition()).getActualParameters().get(i);
                pcs = new PatternCallSignature();
                patternParams[i] = TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)ActualTerm);
                if ((Term)ActualTerm instanceof VariableReference && ruleToBeInterpreted instanceof ForallRule && iteratorBlockRule.getLocalVariables().contains((Object)((VariableReference)ActualTerm).getVariable())) {
                    pcs.setExecutionMode(ExecutionMode.MULTIPLE_RESULTS);
                } else {
                    pcs.setExecutionMode(ExecutionMode.SINGLE_RESULT);
                }
                if (patternParams[i] == null || ValueKind.UNDEF_LITERAL.equals(patternParams[i])) {
                    if ((Term)ActualTerm instanceof VariableReference && iteratorBlockRule.getLocalVariables().contains((Object)((VariableReference)ActualTerm).getVariable())) {
                        pcs.setParameterMode(ParameterMode.OUTPUT);
                        break block17;
                    } else {
                        String[] context = new String[]{"" + i};
                        throw new ASMInterpreterException("As the {1}. parameter is not quantified by the forall/choose rule it must be an INPUT parameter with a non-UNDEF value.", context, (AnnotatedElement)iteratorBlockRule);
                    }
                }
                pcs.setParameterMode(ParameterMode.INPUT);
            }
            if (ActualTerm instanceof VariableReference) {
                variable = ((VariableReference)ActualTerm).getVariable();
                if (parameterScopes.containsKey(variable)) {
                    pcs.setParameterScope(parameterScopes.get(variable));
                } else {
                    pcs.setParameterScope(new Scope());
                }
            } else {
                pcs.setParameterScope(new Scope());
            }
            patternCallSignatures[i] = pcs;
            if (ruleToBeInterpreted instanceof ForallRule) {
                if (ActualTerm instanceof VariableReference) {
                    variable = ((VariableReference)ActualTerm).getVariable();
                    if (iteratorBlockRule.getLocalVariables().indexOf((Object)variable) == -1) {
                        if (paramSize == outerVariableCounterForQuantificationOrder) {
                            this.getNoneUsedVariable(ruleToBeInterpreted);
                        }
                        quantificationOrder[outerVariableCounterForQuantificationOrder] = i;
                        ++outerVariableCounterForQuantificationOrder;
                    } else {
                        quantificationOrder[iteratorBlockRule.getLocalVariables().indexOf((Object)variable)] = i;
                        ++localVariableCounterForQuantificationOrder;
                    }
                } else {
                    quantificationOrder[outerVariableCounterForQuantificationOrder] = i;
                    ++outerVariableCounterForQuantificationOrder;
                }
            }
            ++i;
        }
        return new PatternMatcherParameters(patternCallSignatures, patternParams, quantificationOrder);
    }

    private BlockRuleExecutionEnvironment getNewExecutionEnvironment(IExecutionEnvironment executionEnvironment, CollectionIteratorRule ruleToBeInterpreted) {
        BlockRuleExecutionEnvironment forallRuleExecutionEnvironment = new BlockRuleExecutionEnvironment(executionEnvironment.getFramework(), ruleToBeInterpreted.getBody());
        Hashtable<Variable, Object> variables = new Hashtable<Variable, Object>(executionEnvironment.getVariableValues());
        for (Object variable : ruleToBeInterpreted.getLocalVariables()) {
            variables.put((Variable)variable, ValueKind.UNDEF_LITERAL);
        }
        forallRuleExecutionEnvironment.onBegin(variables);
        return forallRuleExecutionEnvironment;
    }

    private Collection<IMatching> reorder(GTPattern gtPattern, Collection<IMatching> matches) {
        Integer orderColoumn = null;
        boolean orderDesc = false;
        String orderType = "string";
        for (Object annot : gtPattern.getRuntimeAnnotations()) {
            RuntimeAnnotation annot2 = (RuntimeAnnotation)annot;
            if (!"@orderby".equals(annot2.getAnnotationName().toLowerCase())) continue;
            for (Object oRel : annot2.getElements()) {
                RuntimeAnnotationElement rel = (RuntimeAnnotationElement)oRel;
                if ("col".equals(rel.getKey().toLowerCase())) {
                    try {
                        orderColoumn = Integer.parseInt(rel.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("order".equals(rel.getKey().toLowerCase()) && "desc".equals(rel.getValue().toLowerCase())) {
                    orderDesc = true;
                    continue;
                }
                if (!"type".equals(rel.getKey().toLowerCase())) continue;
                orderType = rel.getValue().toLowerCase();
            }
        }
        if (orderColoumn != null) {
            final boolean desc = orderDesc;
            final HashMap<IMatching, Comparable> keys = new HashMap<IMatching, Comparable>();
            for (IMatching match : matches) {
                Object col = match.lookup(orderColoumn.intValue());
                Object key = null;
                if (col == null) {
                    key = null;
                } else if (col instanceof IEntity) {
                    if ("name".equals(orderType)) {
                        key = ((IModelElement)col).getName();
                    } else if ("name-nocase".equals(orderType)) {
                        key = ((IModelElement)col).getName().toLowerCase();
                    } else if ("fqn".equals(orderType)) {
                        key = ((IModelElement)col).getFullyQualifiedName();
                    } else if ("fqn-nocase".equals(orderType)) {
                        key = ((IModelElement)col).getFullyQualifiedName().toLowerCase();
                    } else {
                        String value = ((IEntity)col).getValue();
                        key = "double".equals(orderType) ? Double.valueOf(Double.parseDouble(value)) : ("integer".equals(orderType) ? Integer.valueOf(Integer.parseInt(value)) : ("nocase".equals(orderType) ? value.toLowerCase() : ("value-nocase".equals(orderType) ? value.toLowerCase() : value)));
                    }
                } else {
                    key = col instanceof Comparable ? (Comparable)col : col.toString();
                }
                keys.put(match, (Comparable)key);
            }
            ArrayList<IMatching> matchList = new ArrayList<IMatching>(matches);
            Collections.sort(matchList, new Comparator<IMatching>(){

                @Override
                public int compare(IMatching o1, IMatching o2) {
                    int compareResult = ((Comparable)keys.get(o1)).compareTo(keys.get(o2));
                    return desc ? -compareResult : compareResult;
                }
            });
            matches = matchList;
        }
        return matches;
    }

    public static /* bridge */ /* synthetic */ RuleInterpreter getInstance() {
        return BlockRuleInterpreter.getInstance();
    }
}

