/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.rules;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.codegen.CodeOutputPlugin;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.BasicRuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.BlockRuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.ConditionalRuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.ModelManipulationRuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.NestedRuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleUpdateInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.JavaNativeValue;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.BlockRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.NestedRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ASMRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ConditionalRuleIf;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ConditionalRuleTry;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ModelManipulationRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdate;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Multiplicity;
import org.eclipse.viatra2.interpreters.IProgressReport;
import org.eclipse.viatra2.logger.Logger;

public class RuleInterpreter {
    private static RuleInterpreter INSTANCE = new RuleInterpreter();
    protected Logger log;
    protected CodeOutputPlugin codeout;

    public CodeOutputPlugin getCodeout() {
        return this.codeout;
    }

    public void setCodeout(CodeOutputPlugin codeout) {
        this.codeout = codeout;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    RuleInterpreter() {
    }

    public static RuleInterpreter getInstance() {
        return INSTANCE;
    }

    public Boolean interpretRule(IExecutionEnvironment executionEnvironment, Rule ruleToBeInterpreted, IProgressReport pr) throws ViatraTransformationException {
        try {
            return this.interpretRule(executionEnvironment, ruleToBeInterpreted.getBody(), pr);
        }
        catch (ViatraTransformationException e) {
            throw e.addNewStackElement((EObject)ruleToBeInterpreted);
        }
    }

    protected String convertToJavaType(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return "String";
        }
        if (obj instanceof Integer) {
            return "Integer";
        }
        if (obj instanceof Double) {
            return "Double";
        }
        if (obj instanceof Boolean) {
            return "Boolean";
        }
        if (obj instanceof Multiplicity) {
            return "Multiplicity";
        }
        if (ValueKind.UNDEF_LITERAL.equals(obj)) {
            return "UNDEF";
        }
        if (obj instanceof IRelation) {
            return "Relation (ModelElement)";
        }
        if (obj instanceof IEntity) {
            return "Entity (ModelElement)";
        }
        if (obj instanceof JavaNativeValue) {
            return "JavaNativeValue";
        }
        return "unknown type";
    }

    public Boolean interpretRule(IExecutionEnvironment executionEnvironment, ASMRuleInvocation ruleToBeInterpreted, IProgressReport pr) throws ViatraTransformationException {
        if (pr != null) {
            pr.progress(1);
        }
        if (ruleToBeInterpreted instanceof RuleUpdate) {
            return RuleUpdateInterpreter.getInstance().interpretRule(executionEnvironment, ruleToBeInterpreted, pr);
        }
        if (ruleToBeInterpreted instanceof NestedRule) {
            return NestedRuleInterpreter.getInstance().interpretRule(executionEnvironment, ruleToBeInterpreted, pr);
        }
        if (ruleToBeInterpreted instanceof ConditionalRuleIf || ruleToBeInterpreted instanceof ConditionalRuleTry) {
            return ConditionalRuleInterpreter.getInstance().interpretRule(executionEnvironment, ruleToBeInterpreted, pr);
        }
        if (ruleToBeInterpreted instanceof BlockRule) {
            return BlockRuleInterpreter.getInstance().interpretRule(executionEnvironment, ruleToBeInterpreted, pr);
        }
        if (ruleToBeInterpreted instanceof ModelManipulationRule) {
            return ModelManipulationRuleInterpreter.getInstance().interpretRule(executionEnvironment, ruleToBeInterpreted, pr);
        }
        return BasicRuleInterpreter.getInstance().interpretRule(executionEnvironment, ruleToBeInterpreted, pr);
    }

    public static void initInterpreters(Logger log, CodeOutputPlugin codeout) {
        BasicRuleInterpreter.getInstance().setCodeout(codeout);
        BasicRuleInterpreter.getInstance().setLog(log);
        BlockRuleInterpreter.getInstance().setLog(log);
        ConditionalRuleInterpreter.getInstance().setLog(log);
        NestedRuleInterpreter.getInstance().setLog(log);
        RuleUpdateInterpreter.getInstance().setLog(log);
    }
}

