/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.term.rules;

import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterErrorString;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.MultiplicityKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ArithmeticOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Division;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Minus;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Multiply;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Plus;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Remainder;

public class ArithmeticOperationEvaluator
extends TermEvaluator {
    private static ArithmeticOperationEvaluator _instance = new ArithmeticOperationEvaluator();

    private ArithmeticOperationEvaluator() {
    }

    public static ArithmeticOperationEvaluator getInstance() {
        return _instance;
    }

    public Object evaluate(IExecutionEnvironment executionEnvironment, Term termToBeEvaluated) throws ViatraTransformationException {
        ArithmeticOperation arithmeticOperation = (ArithmeticOperation)termToBeEvaluated;
        if (!(arithmeticOperation.getActualParameters().size() == 2 || arithmeticOperation.getActualParameters().size() == 1 && arithmeticOperation instanceof Minus)) {
            String[] context = new String[]{arithmeticOperation.getName()};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NUM_ARITHMETIC, context, (Term)arithmeticOperation);
        }
        TermEvaluator termEvaluator = TermEvaluator.getInstance();
        Object op1 = termEvaluator.evaluate(executionEnvironment, (Term)arithmeticOperation.getActualParameters().get(0));
        if (ValueKind.UNDEF_LITERAL.equals(op1)) {
            return ValueKind.UNDEF_LITERAL;
        }
        Object op2 = null;
        if (arithmeticOperation.getActualParameters().size() == 2 && ValueKind.UNDEF_LITERAL.equals(op2 = termEvaluator.evaluate(executionEnvironment, (Term)arithmeticOperation.getActualParameters().get(1)))) {
            return ValueKind.UNDEF_LITERAL;
        }
        if (arithmeticOperation instanceof Plus) {
            if (op1 instanceof String || op2 instanceof String) {
                return String.valueOf(this.convertToString(op1)) + this.convertToString(op2);
            }
            if (op1 instanceof Double) {
                if (op2 instanceof Double) {
                    return (Double)op1 + (Double)op2;
                }
                if (op2 instanceof Integer) {
                    return (Double)op1 + Double.valueOf(((Integer)op2).doubleValue());
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Integer) {
                if (op2 instanceof Double) {
                    return ((Integer)op1).doubleValue() + (Double)op2;
                }
                if (op2 instanceof Integer) {
                    return (Integer)op1 + (Integer)op2;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof MultiplicityKind) {
                if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && op2 instanceof MultiplicityKind || MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2) && op1 instanceof MultiplicityKind || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2) || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1)) {
                    return MultiplicityKind.MANY_TO_MANY_LITERAL;
                }
                if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2) || MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) || MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2)) {
                    return MultiplicityKind.MANY_TO_ONE_LITERAL;
                }
                if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2) || MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2)) {
                    return MultiplicityKind.ONE_TO_MANY_LITERAL;
                }
                if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2)) {
                    return MultiplicityKind.ONE_TO_ONE_LITERAL;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    if (!((Boolean)op1).booleanValue() && !((Boolean)op2).booleanValue()) {
                        return false;
                    }
                    return true;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (arithmeticOperation instanceof Minus) {
            if (op1 instanceof Double) {
                if (arithmeticOperation.getActualParameters().size() == 1) {
                    return (Double)op1 * -1.0;
                }
                if (op2 instanceof Double) {
                    return (Double)op1 - (Double)op2;
                }
                if (op2 instanceof Integer) {
                    return (Double)op1 - Double.valueOf(((Integer)op2).doubleValue());
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Integer) {
                if (arithmeticOperation.getActualParameters().size() == 1) {
                    return (Integer)op1 * -1;
                }
                if (op2 instanceof Double) {
                    return ((Integer)op1).doubleValue() - (Double)op2;
                }
                if (op2 instanceof Integer) {
                    return (Integer)op1 - (Integer)op2;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (arithmeticOperation instanceof Multiply) {
            if (op1 instanceof Double) {
                if (op2 instanceof Double) {
                    return (Double)op1 * (Double)op2;
                }
                if (op2 instanceof Integer) {
                    return (Double)op1 * Double.valueOf(((Integer)op2).doubleValue());
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Integer) {
                if (op2 instanceof Double) {
                    return ((Integer)op1).doubleValue() * (Double)op2;
                }
                if (op2 instanceof Integer) {
                    return (Integer)op1 * (Integer)op2;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof MultiplicityKind) {
                if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && op2 instanceof MultiplicityKind || MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2) && op1 instanceof MultiplicityKind || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2) || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1)) {
                    return MultiplicityKind.ONE_TO_ONE_LITERAL;
                }
                if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2) || MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2)) {
                    return MultiplicityKind.ONE_TO_MANY_LITERAL;
                }
                if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2) || MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) || MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2)) {
                    return MultiplicityKind.MANY_TO_ONE_LITERAL;
                }
                if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2)) {
                    return MultiplicityKind.MANY_TO_MANY_LITERAL;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    if (((Boolean)op1).booleanValue() && ((Boolean)op2).booleanValue()) {
                        return true;
                    }
                    return false;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (arithmeticOperation instanceof Division) {
            if (op1 instanceof Double) {
                if (op2 instanceof Double) {
                    return (Double)op1 / (Double)op2;
                }
                if (op2 instanceof Integer) {
                    return (Double)op1 / Double.valueOf(((Integer)op2).doubleValue());
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Integer) {
                if (op2 instanceof Double) {
                    return ((Integer)op1).doubleValue() / (Double)op2;
                }
                if (op2 instanceof Integer) {
                    return (Integer)op1 / (Integer)op2;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (arithmeticOperation instanceof Remainder) {
            if (op1 instanceof Integer) {
                if (op2 instanceof Integer) {
                    return (Integer)op1 % (Integer)op2;
                }
                String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            String[] context = new String[]{arithmeticOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        String[] context = new String[]{arithmeticOperation.getName()};
        throw new TermInterpreterException(TermInterpreterErrorString.UNIMP_ARITHMETIC, context, termToBeEvaluated);
    }

    public String convertToString(Object o) {
        if (o instanceof MultiplicityKind) {
            if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(o)) {
                return "many to many";
            }
            if (MultiplicityKind.ONE_TO_MANY_LITERAL.equals(o)) {
                return "one to many";
            }
            if (MultiplicityKind.MANY_TO_ONE_LITERAL.equals(o)) {
                return "many to one";
            }
            if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(o)) {
                return "one to one";
            }
        }
        return o.toString();
    }

    public static /* bridge */ /* synthetic */ TermEvaluator getInstance() {
        return ArithmeticOperationEvaluator.getInstance();
    }
}

