/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.term.rules;

import java.util.Vector;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterErrorString;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.JavaNativeValue;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.PatternMatcherProvider;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.MultiplicityKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ASMFunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Constant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.NativeFunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.Multiplicity;

public class BasicTermEvaluator
extends TermEvaluator {
    private static BasicTermEvaluator _instance = new BasicTermEvaluator();

    private BasicTermEvaluator() {
    }

    public static BasicTermEvaluator getInstance() {
        return _instance;
    }

    public Object evaluate(IExecutionEnvironment executionEnvironment, Term termToBeEvaluated) throws ViatraTransformationException {
        if (termToBeEvaluated instanceof Constant) {
            int kind = ((Constant)termToBeEvaluated).getKind().getValue();
            switch (kind) {
                case 1: {
                    return Boolean.valueOf(((Constant)termToBeEvaluated).getValue());
                }
                case 4: {
                    return Double.valueOf(((Constant)termToBeEvaluated).getValue());
                }
                case 3: {
                    return Integer.valueOf(((Constant)termToBeEvaluated).getValue());
                }
                case 2: {
                    return ((Constant)termToBeEvaluated).getValue();
                }
                case 6: {
                    if ("one_to_one".equals(((Constant)termToBeEvaluated).getValue())) {
                        return MultiplicityKind.ONE_TO_ONE_LITERAL;
                    }
                    if ("one_to_many".equals(((Constant)termToBeEvaluated).getValue())) {
                        return MultiplicityKind.ONE_TO_MANY_LITERAL;
                    }
                    if ("many_to_many".equals(((Constant)termToBeEvaluated).getValue())) {
                        return MultiplicityKind.MANY_TO_MANY_LITERAL;
                    }
                    if ("many_to_one".equals(((Constant)termToBeEvaluated).getValue())) {
                        return MultiplicityKind.MANY_TO_ONE_LITERAL;
                    }
                }
                case 0: {
                    return ValueKind.UNDEF_LITERAL;
                }
                case 5: {
                    String fqn = ((Constant)termToBeEvaluated).getValue();
                    if (fqn == null) {
                        String[] context = new String[]{"Fully Qualified Name"};
                        throw new TermInterpreterException(TermInterpreterErrorString.REF_NOT_STRING_MODELELEMENTQUERY, context, termToBeEvaluated);
                    }
                    IModelElement result = executionEnvironment.getFramework().getTopmodel().getModelManager().getElementByName(fqn);
                    if (result != null) {
                        return result;
                    }
                    String[] context = new String[]{fqn};
                    throw new TermInterpreterException("The referred modelelement constant '{1}' is not present in the model space.", context, termToBeEvaluated);
                }
            }
            String[] context = new String[]{termToBeEvaluated.getName()};
            throw new TermInterpreterException(TermInterpreterErrorString.UNIMP_TERM, context, termToBeEvaluated);
        }
        if (termToBeEvaluated instanceof ASMFunctionInvocation) {
            BasicEList evalParamList = new BasicEList();
            for (Object term : ((ASMFunctionInvocation)termToBeEvaluated).getActualParameters()) {
                evalParamList.add(TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)term));
            }
            Object value = executionEnvironment.getValueOfASMFunction(((ASMFunctionInvocation)termToBeEvaluated).getCalledFunction(), (EList)evalParamList);
            return value == null ? ValueKind.UNDEF_LITERAL : value;
        }
        if (termToBeEvaluated instanceof NativeFunctionInvocation) {
            String functionName = ((NativeFunctionInvocation)termToBeEvaluated).getFunctionName();
            Object[] parameters = new Object[((NativeFunctionInvocation)termToBeEvaluated).getActualParameters().size()];
            int i = 0;
            for (Object parameterToBeEvaluated : ((NativeFunctionInvocation)termToBeEvaluated).getActualParameters()) {
                Object currparameter = TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)parameterToBeEvaluated);
                parameters[i++] = currparameter instanceof JavaNativeValue ? ((JavaNativeValue)currparameter).getValue() : currparameter;
            }
            try {
                Object o = executionEnvironment.getFramework().getNativeFunctionManager().getNativeFunctionForName(functionName).evaluate(executionEnvironment.getFramework().getTopmodel(), parameters);
                if (this.isASMNativeType(o).booleanValue()) {
                    return o;
                }
                return new JavaNativeValue(o);
            }
            catch (VPMRuntimeException e) {
                String[] context = new String[]{e.getMessage()};
                throw new TermInterpreterException(TermInterpreterErrorString.VPM_CORE, context, termToBeEvaluated);
            }
        }
        if (termToBeEvaluated instanceof VariableReference) {
            try {
                return executionEnvironment.getVariableValue(((VariableReference)termToBeEvaluated).getVariable());
            }
            catch (ViatraTransformationException e) {
                String[] context = new String[]{((VariableReference)termToBeEvaluated).getName()};
                throw new TermInterpreterException(String.valueOf(TermInterpreterErrorString.EXECUTION_ENVIRONMENT_EXCEPTION) + e.getMessage(), context, termToBeEvaluated);
            }
        }
        if (termToBeEvaluated instanceof GTPatternCall) {
            GTPattern gtPattern = ((GTPatternCall)termToBeEvaluated).getCalledPattern();
            try {
                IPatternMatcher patternMatcher = PatternMatcherProvider.getInstance().getPatternMatcher(executionEnvironment, gtPattern);
                Vector<Object> patternParams = new Vector<Object>();
                for (Object term : ((GTPatternCall)termToBeEvaluated).getActualParameters()) {
                    patternParams.add(TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)term));
                }
                return patternMatcher.match(patternParams.toArray());
            }
            catch (ViatraTransformationException e) {
                throw e.addNewStackElement((EObject)termToBeEvaluated);
            }
        }
        if (termToBeEvaluated instanceof Multiplicity) {
            return termToBeEvaluated;
        }
        String[] context = new String[]{termToBeEvaluated.getName()};
        throw new TermInterpreterException(TermInterpreterErrorString.UNIMP_TERM, context, termToBeEvaluated);
    }

    public static /* bridge */ /* synthetic */ TermEvaluator getInstance() {
        return BasicTermEvaluator.getInstance();
    }
}

