/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.term.rules;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterErrorString;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.MultiplicityKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ConversionOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToBoolean;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToDouble;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToInt;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToMultiplicity;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ToString;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.impl.MultiplicityImpl;

public class ConversionOperationEvaluator
extends TermEvaluator {
    private static ConversionOperationEvaluator _instance = new ConversionOperationEvaluator();

    private ConversionOperationEvaluator() {
    }

    public static ConversionOperationEvaluator getInstance() {
        return _instance;
    }

    public Object evaluate(IExecutionEnvironment executionEnvironment, Term termToBeEvaluated) throws ViatraTransformationException {
        ConversionOperation conversionOperation = (ConversionOperation)termToBeEvaluated;
        if (conversionOperation.getActualParameters().size() != 1) {
            String[] context = new String[]{conversionOperation.getName()};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NUM_CONVERSION, context, (Term)conversionOperation);
        }
        Term term = (Term)conversionOperation.getActualParameters().get(0);
        Object op1 = TermEvaluator.getInstance().evaluate(executionEnvironment, term);
        if (conversionOperation instanceof ToBoolean) {
            Boolean result = this.object2Boolean(op1, conversionOperation);
            return result == null ? ValueKind.UNDEF_LITERAL : result;
        }
        if (conversionOperation instanceof ToString) {
            return op1.toString();
        }
        if (conversionOperation instanceof ToInt) {
            if (op1 instanceof Integer) {
                return op1;
            }
            if (op1 instanceof Double) {
                return ((Double)op1).intValue();
            }
            if (op1 instanceof String) {
                try {
                    return Integer.valueOf((String)op1);
                }
                catch (NumberFormatException numberFormatException) {
                    String[] context = new String[]{(String)op1, "Integer", conversionOperation.getName()};
                    throw new TermInterpreterException("'{1}' could not be converted to a(n) {2} by the {3} conversion operation.", context, termToBeEvaluated);
                }
            }
            if (op1 instanceof Boolean) {
                return (Boolean)op1 != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            if (ValueKind.UNDEF_LITERAL.equals(op1)) {
                return ValueKind.UNDEF_LITERAL;
            }
            String[] context = new String[]{this.convertToJavaType(op1), conversionOperation.getName()};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_ONE_PARAM, context, termToBeEvaluated);
        }
        if (conversionOperation instanceof ToDouble) {
            if (op1 instanceof Double) {
                return op1;
            }
            if (op1 instanceof Integer) {
                return new Double(((Integer)op1).doubleValue());
            }
            if (op1 instanceof String) {
                try {
                    return new Double((String)op1);
                }
                catch (NumberFormatException numberFormatException) {
                    String[] context = new String[]{(String)op1, "Double", conversionOperation.getName()};
                    throw new TermInterpreterException("'{1}' could not be converted to a(n) {2} by the {3} conversion operation.", context, termToBeEvaluated);
                }
            }
            if (op1 instanceof Boolean) {
                return (Boolean)op1 != false ? Double.valueOf(1.0) : Double.valueOf(0.0);
            }
            if (ValueKind.UNDEF_LITERAL.equals(op1)) {
                return ValueKind.UNDEF_LITERAL;
            }
            String[] context = new String[]{this.convertToJavaType(op1), conversionOperation.getName()};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_ONE_PARAM, context, termToBeEvaluated);
        }
        if (conversionOperation instanceof ToMultiplicity) {
            if (op1 instanceof MultiplicityImpl) {
                return op1;
            }
            if (op1 instanceof String) {
                String value = (String)op1;
                if (value.compareToIgnoreCase("one-to-one") == 0) {
                    return MultiplicityKind.ONE_TO_ONE_LITERAL;
                }
                if (value.compareToIgnoreCase("one-to-many") == 0) {
                    return MultiplicityKind.ONE_TO_MANY_LITERAL;
                }
                if (value.compareToIgnoreCase("many-to-one") == 0) {
                    return MultiplicityKind.MANY_TO_ONE_LITERAL;
                }
                if (value.compareToIgnoreCase("many-to-many") == 0) {
                    return MultiplicityKind.MANY_TO_MANY_LITERAL;
                }
                String[] context = new String[]{value, "Multiplicity", conversionOperation.getName()};
                throw new TermInterpreterException("'{1}' could not be converted to a(n) {2} by the {3} conversion operation.", context, termToBeEvaluated);
            }
            if (ValueKind.UNDEF_LITERAL.equals(op1)) {
                return ValueKind.UNDEF_LITERAL;
            }
            String[] context = new String[]{this.convertToJavaType(op1), conversionOperation.getName()};
            throw new TermInterpreterException("The input parameter of the {1} operation can not be converted to Multiplicity as its type is {2}.", context, termToBeEvaluated);
        }
        String[] context = new String[]{conversionOperation.getName()};
        throw new TermInterpreterException(TermInterpreterErrorString.UNIMP_CONVERSION, context, termToBeEvaluated);
    }

    protected Boolean object2Boolean(Object obj, ConversionOperation toBoolean) throws TermInterpreterException {
        if (obj instanceof String) {
            return "true".equals(obj) ? Boolean.TRUE : ("false".equals(obj) ? Boolean.FALSE : null);
        }
        if (obj instanceof Double) {
            return ((Double)obj).equals(0.0) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).equals(0) ? Boolean.FALSE : Boolean.TRUE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj.equals(ValueKind.UNDEF_LITERAL)) {
            return Boolean.FALSE;
        }
        if (obj instanceof IModelElement) {
            return Boolean.TRUE;
        }
        String[] context = new String[]{toBoolean.getName(), this.convertToJavaType(obj)};
        throw new TermInterpreterException("The input parameter of the {1} operation can not be converted to Boolean as its type is {2}.", context, (Term)toBoolean);
    }

    public static /* bridge */ /* synthetic */ TermEvaluator getInstance() {
        return ConversionOperationEvaluator.getInstance();
    }
}

