/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.term.rules;

import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterErrorString;
import org.eclipse.viatra2.gtasm.interpreter.term.internal.TermInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.MultiplicityKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.And;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Equals;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.GreaterThan;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.GreaterThanOrEqualTo;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.LessThan;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.LessThanOrEqualTo;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Not;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.NotEquals;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.Or;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.RelationalOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.XOr;

public class RelationalOperationEvaluator
extends TermEvaluator {
    private static RelationalOperationEvaluator _instance = new RelationalOperationEvaluator();

    private RelationalOperationEvaluator() {
    }

    public static RelationalOperationEvaluator getInstance() {
        return _instance;
    }

    public Object evaluate(IExecutionEnvironment executionEnvironment, Term termToBeEvaluated) throws ViatraTransformationException {
        RelationalOperation relationalOperation = (RelationalOperation)termToBeEvaluated;
        if (relationalOperation instanceof Not) {
            Object op1 = TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)relationalOperation.getActualParameters().get(0));
            if (op1 instanceof Boolean) {
                return (Boolean)op1 == false;
            }
            String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1)};
            throw new TermInterpreterException("The input parameter of the {1} operation can not be converted to Boolean as its type is {2}.", context, (Term)relationalOperation);
        }
        if (relationalOperation.getActualParameters().size() != 2) {
            String[] context = new String[]{relationalOperation.getName()};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NUM_RELATIONAL, context, (Term)relationalOperation);
        }
        Object op1 = TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)relationalOperation.getActualParameters().get(0));
        Object op2 = TermEvaluator.getInstance().evaluate(executionEnvironment, (Term)relationalOperation.getActualParameters().get(1));
        if (relationalOperation instanceof And) {
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    if (((Boolean)op1).booleanValue() && ((Boolean)op2).booleanValue()) {
                        return true;
                    }
                    return false;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof MultiplicityKind) {
                if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && op2 instanceof MultiplicityKind || MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2) && op1 instanceof MultiplicityKind || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2) || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1)) {
                    return MultiplicityKind.ONE_TO_ONE_LITERAL;
                }
                if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2) || MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2)) {
                    return MultiplicityKind.ONE_TO_MANY_LITERAL;
                }
                if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2) || MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) || MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2)) {
                    return MultiplicityKind.MANY_TO_ONE_LITERAL;
                }
                if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2)) {
                    return MultiplicityKind.MANY_TO_MANY_LITERAL;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (relationalOperation instanceof Or) {
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    if (!((Boolean)op1).booleanValue() && !((Boolean)op2).booleanValue()) {
                        return false;
                    }
                    return true;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof MultiplicityKind) {
                if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && op2 instanceof MultiplicityKind || MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2) && op1 instanceof MultiplicityKind || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2) || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1)) {
                    return MultiplicityKind.MANY_TO_MANY_LITERAL;
                }
                if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2) || MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) || MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op2)) {
                    return MultiplicityKind.MANY_TO_ONE_LITERAL;
                }
                if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2) || MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) || MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op2)) {
                    return MultiplicityKind.ONE_TO_MANY_LITERAL;
                }
                if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2)) {
                    return MultiplicityKind.ONE_TO_ONE_LITERAL;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (relationalOperation instanceof XOr) {
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    return !((Boolean)op1).equals(op2);
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (relationalOperation instanceof NotEquals) {
            if (op1 instanceof Integer) {
                if (op2 instanceof Double) {
                    if ((double)((Integer)op1).intValue() != (Double)op2) {
                        return true;
                    }
                    return false;
                }
                return !op1.equals(op2);
            }
            if (op1 instanceof Double) {
                if (op2 instanceof Integer) {
                    if ((Double)op1 != (double)((Integer)op2).intValue()) {
                        return true;
                    }
                    return false;
                }
                return !op1.equals(op2);
            }
            return !op1.equals(op2);
        }
        if (relationalOperation instanceof Equals) {
            if (op1 instanceof Integer) {
                if (op2 instanceof Double) {
                    if ((double)((Integer)op1).intValue() == (Double)op2) {
                        return true;
                    }
                    return false;
                }
                return op1.equals(op2);
            }
            if (op1 instanceof Double) {
                if (op2 instanceof Integer) {
                    if ((Double)op1 == (double)((Integer)op2).intValue()) {
                        return true;
                    }
                    return false;
                }
                return op1.equals(op2);
            }
            return op1.equals(op2);
        }
        if (relationalOperation instanceof LessThan) {
            if (op1 instanceof Integer) {
                if (op2 instanceof Integer) {
                    if ((Integer)op1 < (Integer)op2) {
                        return true;
                    }
                    return false;
                }
                if (op2 instanceof Double) {
                    if (Double.valueOf(((Integer)op1).doubleValue()) < (Double)op2) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Double) {
                if (op2 instanceof Integer) {
                    Double d = new Double(((Integer)op2).intValue());
                    if ((Double)op1 < d) {
                        return true;
                    }
                    return false;
                }
                if (op2 instanceof Double) {
                    if ((Double)op1 < (Double)op2) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof String) {
                if (op2 instanceof String) {
                    if (((String)op1).compareTo((String)op2) < 0) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    return (Boolean)op1 == false ? (Boolean)op2 : Boolean.FALSE;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof MultiplicityKind) {
                if (op2 instanceof MultiplicityKind) {
                    if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && !MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (ValueKind.UNDEF_LITERAL.equals(op1)) {
                return Boolean.FALSE;
            }
            String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (relationalOperation instanceof GreaterThan) {
            if (op1 instanceof Integer) {
                if (op2 instanceof Integer) {
                    if ((Integer)op1 > (Integer)op2) {
                        return true;
                    }
                    return false;
                }
                if (op2 instanceof Double) {
                    if (Double.valueOf(((Integer)op1).doubleValue()) > (Double)op2) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Double) {
                if (op2 instanceof Integer) {
                    Double d = new Double(((Integer)op2).intValue());
                    if ((Double)op1 > d) {
                        return true;
                    }
                    return false;
                }
                if (op2 instanceof Double) {
                    if ((Double)op1 > (Double)op2) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof String) {
                if (op2 instanceof String) {
                    if (((String)op1).compareTo((String)op2) > 0) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    return ((Boolean)op1).booleanValue() ? !((Boolean)op2).booleanValue() : Boolean.FALSE;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof MultiplicityKind) {
                if (op2 instanceof MultiplicityKind) {
                    if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && !MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (ValueKind.UNDEF_LITERAL.equals(op1)) {
                return Boolean.FALSE;
            }
            String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (relationalOperation instanceof LessThanOrEqualTo) {
            if (op1 instanceof Integer) {
                if (op2 instanceof Integer) {
                    if ((Integer)op1 <= (Integer)op2) {
                        return true;
                    }
                    return false;
                }
                if (op2 instanceof Double) {
                    if (Double.valueOf(((Integer)op1).doubleValue()) <= (Double)op2) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Double) {
                if (op2 instanceof Integer) {
                    Double d = new Double(((Integer)op2).intValue());
                    if ((Double)op1 <= d) {
                        return true;
                    }
                    return false;
                }
                if (op2 instanceof Double) {
                    if ((Double)op1 <= (Double)op2) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof String) {
                if (op2 instanceof String) {
                    return ((String)op2).indexOf((String)op1) != -1;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    return (Boolean)op1 != false ? (Boolean)op2 : Boolean.TRUE;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof MultiplicityKind) {
                if (op2 instanceof MultiplicityKind) {
                    if (MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op1) && !MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (op1.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (ValueKind.UNDEF_LITERAL.equals(op1)) {
                return Boolean.FALSE;
            }
            String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        if (relationalOperation instanceof GreaterThanOrEqualTo) {
            if (op1 instanceof Integer) {
                if (op2 instanceof Integer) {
                    if ((Integer)op1 >= (Integer)op2) {
                        return true;
                    }
                    return false;
                }
                if (op2 instanceof Double) {
                    if (Double.valueOf(((Integer)op1).doubleValue()) >= (Double)op2) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Double) {
                if (op2 instanceof Integer) {
                    Double d = new Double(((Integer)op2).intValue());
                    if ((Double)op1 >= d) {
                        return true;
                    }
                    return false;
                }
                if (op2 instanceof Double) {
                    if ((Double)op1 >= (Double)op2) {
                        return true;
                    }
                    return false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof String) {
                if (op2 instanceof String) {
                    return ((String)op1).indexOf((String)op2) != -1;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof Boolean) {
                if (op2 instanceof Boolean) {
                    return (Boolean)op1 != false ? Boolean.TRUE : (Boolean)op2 == false;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (op1 instanceof MultiplicityKind) {
                if (op2 instanceof MultiplicityKind) {
                    if (MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op1) && !MultiplicityKind.MANY_TO_MANY_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (MultiplicityKind.ONE_TO_MANY_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (MultiplicityKind.MANY_TO_ONE_LITERAL.equals(op1) && MultiplicityKind.ONE_TO_ONE_LITERAL.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    if (op1.equals(op2)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                if (ValueKind.UNDEF_LITERAL.equals(op2)) {
                    return Boolean.FALSE;
                }
                String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
                throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_2, context, termToBeEvaluated);
            }
            if (ValueKind.UNDEF_LITERAL.equals(op1)) {
                return Boolean.FALSE;
            }
            String[] context = new String[]{relationalOperation.getName(), this.convertToJavaType(op1), this.convertToJavaType(op2)};
            throw new TermInterpreterException(TermInterpreterErrorString.PARAM_NOT_SUITABLE_WITH_OPERATION_1, context, termToBeEvaluated);
        }
        String[] context = new String[]{relationalOperation.getName()};
        throw new TermInterpreterException(TermInterpreterErrorString.UNIMP_RELATIONAL, context, termToBeEvaluated);
    }

    public static /* bridge */ /* synthetic */ TermEvaluator getInstance() {
        return RelationalOperationEvaluator.getInstance();
    }
}

