/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.exception;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.ChooseRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.ForallRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.LetRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.Annotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.GTASMElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Constant;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GTASMException
extends ViatraTransformationException {
    private static final long serialVersionUID = -3717049954955553256L;
    protected ArrayList<StackTraceElement> interpreterStackTrace = new ArrayList();

    public GTASMException(String msg, String[] context) {
        super(msg, context);
    }

    public GTASMException(String msg, String[] context, Throwable cause) {
        super(msg, context, cause);
    }

    public Collection<StackTraceElement> getStackTraceCollection() {
        return this.interpreterStackTrace;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] array = new StackTraceElement[this.interpreterStackTrace.size()];
        return this.interpreterStackTrace.toArray(array);
    }

    @Override
    public void printStackTrace() {
        StackTraceElement[] stackTrace = this.getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            System.err.println("[" + (stackTrace.length - i) + "] " + stackTrace[i].toString());
            ++i;
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        StackTraceElement[] stackTrace = this.getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            s.println("[" + (stackTrace.length - i) + "] " + stackTrace[i].toString());
            ++i;
        }
    }

    @Override
    public void printStackTrace(PrintWriter arg0) {
        StackTraceElement[] stackTrace = this.getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            arg0.println(stackTrace[i].toString());
            ++i;
        }
    }

    @Override
    public ViatraTransformationException addNewStackElement(EObject element) {
        if (element != null && element instanceof AnnotatedElement) {
            StackTraceElement _ste = GTASMException.createStackTraceElement((AnnotatedElement)element);
            this.interpreterStackTrace.add(_ste);
        }
        return this;
    }

    private static String getMachineFQN(EObject element) {
        while (!(element.eContainer() instanceof Machine) && element.eContainer() != null) {
            element = element.eContainer();
        }
        if (element.eContainer() == null) {
            return "Error, element not under any machine!!!";
        }
        return ((Machine)element.eContainer()).getName();
    }

    protected static StackTraceElement createStackTraceElement(AnnotatedElement element) {
        int size = element.getAnnotations().size();
        String sourceFile = "";
        String elementName = "";
        int sourceLine = -1;
        int j = 0;
        while (j < size) {
            String value;
            Annotation annotation = (Annotation)element.getAnnotations().get(j);
            if (annotation.getKey().equals("sourcefile")) {
                sourceFile = new File(annotation.getValue()).getName();
            } else if (annotation.getKey().equals("sourceline")) {
                value = annotation.getValue();
                sourceLine = value == null || value == "" ? -1 : Integer.parseInt(value);
            } else if (annotation.getKey().equals("node_info")) {
                value = annotation.getValue();
                sourceLine = value == null || value == "" ? -1 : Integer.parseInt(value.substring(0, value.indexOf(44)));
            }
            ++j;
        }
        elementName = element instanceof GTASMElement && ((GTASMElement)element).getName() != null ? ((GTASMElement)element).getName() : (element instanceof ModelElement && ((ModelElement)element).getName() != null ? ((ModelElement)element).getName() : (element instanceof Constant ? "Constant value =" + ((Constant)element).getValue() : (element instanceof ForallRule ? "forall" : (element instanceof ChooseRule ? "choose" : (element instanceof LetRule ? "let" : element.eClass().getName())))));
        return new StackTraceElement(GTASMException.getMachineFQN((EObject)element), elementName, sourceFile, sourceLine);
    }

    public String getSerializedStackTrace() {
        String buffer = this.getMessage();
        StackTraceElement[] stackTrace = this.getStackTrace();
        int i = 0;
        while (i < stackTrace.length) {
            buffer = String.valueOf(buffer) + System.getProperty("line.separator") + stackTrace[i].toString();
            ++i;
        }
        return buffer;
    }
}

