/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DirectionKind implements Enumerator
{
    IN_LITERAL(0, "in", "in"),
    INOUT_LITERAL(1, "inout", "inout"),
    OUT_LITERAL(2, "out", "out");

    public static final String copyright = " * Copyright (c) 2006-2010 Istvan Rath and Daniel Varro\r\n * All rights reserved. This program and the accompanying materials\r\n * are made available under the terms of the Eclipse Public License v1.0\r\n * which accompanies this distribution, and is available at\r\n * http://www.eclipse.org/legal/epl-v10.html\r\n *\r\n * Contributors:\r\n *    Istvan Rath, Daniel Varro - initial API and implementation\r\n";
    public static final int IN = 0;
    public static final int INOUT = 1;
    public static final int OUT = 2;
    private static final DirectionKind[] VALUES_ARRAY;
    public static final List<DirectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DirectionKind[]{IN_LITERAL, INOUT_LITERAL, OUT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DirectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionKind get(int value) {
        switch (value) {
            case 0: {
                return IN_LITERAL;
            }
            case 1: {
                return INOUT_LITERAL;
            }
            case 2: {
                return OUT_LITERAL;
            }
        }
        return null;
    }

    private DirectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

