/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LogLevel implements Enumerator
{
    DEBUG_LITERAL(0, "debug", "debug"),
    WARNING_LITERAL(1, "warning", "warning"),
    ERROR_LITERAL(2, "error", "error"),
    FATAL_LITERAL(3, "fatal", "fatal"),
    INFO_LITERAL(4, "info", "info");

    public static final String copyright = " * Copyright (c) 2006-2010 Istvan Rath and Daniel Varro\r\n * All rights reserved. This program and the accompanying materials\r\n * are made available under the terms of the Eclipse Public License v1.0\r\n * which accompanies this distribution, and is available at\r\n * http://www.eclipse.org/legal/epl-v10.html\r\n *\r\n * Contributors:\r\n *    Istvan Rath, Daniel Varro - initial API and implementation\r\n";
    public static final int DEBUG = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL = 3;
    public static final int INFO = 4;
    private static final LogLevel[] VALUES_ARRAY;
    public static final List<LogLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LogLevel[]{DEBUG_LITERAL, WARNING_LITERAL, ERROR_LITERAL, FATAL_LITERAL, INFO_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LogLevel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogLevel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogLevel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LogLevel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LogLevel get(int value) {
        switch (value) {
            case 0: {
                return DEBUG_LITERAL;
            }
            case 1: {
                return WARNING_LITERAL;
            }
            case 2: {
                return ERROR_LITERAL;
            }
            case 3: {
                return FATAL_LITERAL;
            }
            case 4: {
                return INFO_LITERAL;
            }
        }
        return null;
    }

    private LogLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

