/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation;

import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateConstant2Constant;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.ConstantSearchGraphNode;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class CreateRelationConstant2Constant
extends CreateConstant2Constant {
    ConstantSearchGraphNode sourceNode;
    ConstantSearchGraphNode targetNode;

    public CreateRelationConstant2Constant(ConstantSearchGraphNode s, ConstantSearchGraphNode t, int variableI, IModelManager manager) {
        super(manager, variableI);
        this.sourceNode = s;
        this.targetNode = t;
        this.source = manager.getElementByName(s.getElement());
        this.target = manager.getElementByName(t.getElement());
    }

    protected boolean create(MatchingFrame frame) throws GTOperationException {
        if (this.source == null) {
            String[] context = new String[]{this.sourceNode.getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.sourceNode.getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.target == null) {
            String[] context = new String[]{this.targetNode.getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.targetNode.getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            frame.setValue(this.variableIndex, this.manager.newRelation(this.source, this.target));
        }
        catch (VPMCoreException e) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getName(), e.getMessage()};
            throw new GTOperationException("[INTERNAL ERROR] Relation '{1}' creation failed due to: {2}", context, frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement());
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.source.getName() + " -- Relation:" + this.variableIndex + " -> " + this.target.getName();
    }

    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement();
    }
}

