/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.patternmatcher.ExecutionMode;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherCompileTimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.PatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.SearchPlan;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.FlattenedPattern;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.DummyOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.SearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.ITermHandler;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.logger.Logger;

public class HackedPatternMatcher
extends PatternMatcher {
    FlattenedPattern[] flattenedPatterns = this.root.getFlattenedPatterns();

    public HackedPatternMatcher(GTPattern pattern, Logger logger, IModelManager manager, ITermHandler termHandler) throws PatternMatcherCompileTimeException {
        super(pattern, logger, manager, termHandler);
    }

    public IMatching match(Object[] inputMapping, PatternCallSignature[] signature) throws ViatraTransformationException {
        FlattenedPattern[] flattenedPatternArray = this.flattenedPatterns;
        int n = this.flattenedPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            FlattenedPattern pattern = flattenedPatternArray[n2];
            IMatching frame = this.internalMatch(inputMapping, signature, pattern);
            if (frame != null) {
                boolean constraintsFulfilled = true;
                int i = 0;
                while (constraintsFulfilled && i < signature.length) {
                    if (signature[i].getParameterMode() == ParameterMode.OUTPUT) {
                        Scope s = signature[i].getParameterScope();
                        IEntity container = (IEntity)s.getParent();
                        Object obj = frame.lookup(i);
                        if (obj instanceof IModelElement) {
                            IModelElement me = (IModelElement)obj;
                            if (s.getContainmentMode() == 0) {
                                constraintsFulfilled = me.getNamespace().compareTo((Object)container) == 0;
                            } else if (s.getContainmentMode() == 1) {
                                constraintsFulfilled = me.isBelowNamespace((IModelElement)container);
                            }
                        }
                    }
                    ++i;
                }
                if (constraintsFulfilled) {
                    return frame;
                }
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IMatching internalMatch(Object[] inputMapping, PatternCallSignature[] signature, FlattenedPattern flattenedPattern) throws ViatraTransformationException {
        Scope s;
        int strongestConstraint;
        Vector<Object> vec;
        Boolean[] adornment;
        MatchingFrame frame;
        block19: {
            int i = 0;
            while (i < signature.length) {
                if (signature[i].getExecutionMode() == ExecutionMode.MULTIPLE_RESULTS) {
                    this.logger.debug("The method match(Object[], PatternCallSignature[] has been invoked in MULTIPLE_RESULTS execution mode.");
                    return null;
                }
                ++i;
            }
            Integer[] quantificationOrder = new Integer[signature.length];
            int i2 = 0;
            while (i2 < quantificationOrder.length) {
                quantificationOrder[i2] = i2;
                ++i2;
            }
            if (signature.length != quantificationOrder.length) {
                String[] context = new String[]{this.root.getPattern().getName()};
                throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The number of signatures and quantification orders for the {1} pattern call do not match.", context, (AnnotatedElement)this.root.getPattern());
            }
            int multipleUpperBound = 0;
            Vector<Integer> vector = new Vector<Integer>();
            int i3 = 0;
            while (i3 < quantificationOrder.length) {
                Integer index = quantificationOrder[i3];
                if (index >= signature.length) {
                    String[] context = new String[]{this.root.getPattern().getName()};
                    throw new PatternMatcherRuntimeException("[INETRNAL ERROR] Error in the quantification order of the {1}'s pattern call.", context, (AnnotatedElement)this.root.getPattern());
                }
                if (signature[index].getExecutionMode() == ExecutionMode.MULTIPLE_RESULTS) {
                    if (i3 > multipleUpperBound) {
                        String[] context = new String[]{this.root.getPattern().getName()};
                        throw new PatternMatcherRuntimeException("[INETRNAL ERROR] Error in the quantification order of the {1}'s pattern call.", context, (AnnotatedElement)this.root.getPattern());
                    }
                    vector.add(index);
                    ++multipleUpperBound;
                }
                ++i3;
            }
            Integer[] keys = new Integer[vector.size()];
            vector.toArray(keys);
            frame = new MatchingFrame(flattenedPattern);
            adornment = new Boolean[signature.length];
            vec = new Vector<Object>();
            int i4 = 0;
            while (i4 < signature.length) {
                if (signature[i4].getParameterMode() == ParameterMode.INPUT) {
                    adornment[i4] = true;
                    vec.add(inputMapping[i4]);
                    frame.setValue(i4, inputMapping[i4]);
                } else {
                    adornment[i4] = false;
                }
                ++i4;
            }
            strongestConstraint = 0;
            if (vec.size() != 0) break block19;
            int largestDistance = 0;
            boolean hasInConstraint = false;
            int i5 = 0;
            while (i5 < signature.length) {
                block21: {
                    int distance;
                    block20: {
                        s = signature[i5].getParameterScope();
                        distance = 0;
                        IEntity parent = (IEntity)s.getParent();
                        distance = 0;
                        while (!parent.equals(this.manager.getRoot())) {
                            parent = parent.getParent();
                            ++distance;
                        }
                        if (s.getContainmentMode() != 0) break block20;
                        if (hasInConstraint && distance > largestDistance) {
                            largestDistance = distance;
                            strongestConstraint = i5;
                            break block21;
                        } else if (!hasInConstraint) {
                            hasInConstraint = true;
                            largestDistance = distance;
                            strongestConstraint = i5;
                        }
                        break block21;
                    }
                    if (s.getContainmentMode() == 1 && !hasInConstraint && distance > largestDistance) {
                        largestDistance = distance;
                        strongestConstraint = i5;
                    }
                }
                ++i5;
            }
            adornment[strongestConstraint] = true;
        }
        SearchPlanOperation[] t = new SearchPlanOperation[1];
        List<SearchPlanOperation> operations = flattenedPattern.generateSearchPlan(adornment, this.manager);
        operations.add(new DummyOperation());
        SearchPlan searchPlan = new SearchPlan(operations.toArray(t));
        if (vec.size() != 0) {
            if (!searchPlan.execute(frame)) return null;
            return frame;
        }
        s = signature[strongestConstraint].getParameterScope();
        IEntity parent = (IEntity)s.getParent();
        Iterator i = s.getContainmentMode() == 0 ? parent.getElementsInNamespace().iterator() : parent.getAllElementsInNamespace().iterator();
        while (i.hasNext()) {
            MatchingFrame framenoBound = new MatchingFrame(flattenedPattern);
            framenoBound.setValue(strongestConstraint, i.next());
            if (!searchPlan.execute(framenoBound)) continue;
            return framenoBound;
        }
        return null;
    }
}

