/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherCompileTimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.SearchPlan;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.SearchPlanKey;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.VariableID;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms.ISearchGraph;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms.SearchGraphFactory;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.EvenLevelNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.IFlattenedPatternElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.DummyOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.InjectivityCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.PatternCallOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.SearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.IQueueContentProvider;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.IndexedRule;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.LocalGoal;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.MagicSet;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.RemoteGoal;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.UnindexedRule;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.AbstractNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.ITermHandler;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlattenedPattern
extends EvenLevelNode
implements Comparable<FlattenedPattern> {
    private boolean isRecursionBased;
    private ISearchGraph searchGraph;
    private Map<VariableID, Integer> variableMapping;
    private Map<Integer, Set<VariableID>> inverseVariableMapping;
    private Set<Pair> injectivityExclusionSet;
    private Set<Pair> injectivityInclusionSet;
    private Map<SearchPlanKey, Collection<SearchPlan>> searchPlanMapping;
    private Vector<SearchPlanOperation> preSearchPlanOperations;
    private Vector<SearchPlanOperation> postSearchPlanOperations;
    private int frameSize;
    private int injectivityFrameSize;

    public FlattenedPattern(PatternNode parent, List<IFlattenedPatternElement> specification) throws PatternMatcherCompileTimeException {
        super(parent);
        IFlattenedPatternElement element;
        this.searchGraph = SearchGraphFactory.getSearchGraph(parent.getModelManager());
        this.variableMapping = new HashMap<VariableID, Integer>();
        this.inverseVariableMapping = new TreeMap<Integer, Set<VariableID>>();
        this.searchPlanMapping = new HashMap<SearchPlanKey, Collection<SearchPlan>>();
        this.preSearchPlanOperations = new Vector();
        this.postSearchPlanOperations = new Vector();
        this.isRecursionBased = false;
        this.frameSize = 0;
        this.injectivityFrameSize = 0;
        this.injectivityExclusionSet = new HashSet<Pair>();
        this.injectivityInclusionSet = new HashSet<Pair>();
        Logger logger = parent.getLogger();
        int i = 0;
        while (i < specification.size()) {
            element = specification.get(i);
            element.setCurrentLocation(i);
            element.addFormalParameters(this);
            element.addLocalVariables(this);
            ++i;
        }
        this.injectivityFrameSize = this.frameSize;
        i = 0;
        while (i < specification.size()) {
            element = specification.get(i);
            element.processNegativeApplicationConditions(this, logger, parent.getModelManager());
            element.processCheckExpressions(this, logger);
            element.buildSearchGraph(this);
            element.generateElementInjectivityConstraints(this, element.processVariableAssignments(this), element.processInjectivityAssignments(this));
            ++i;
        }
        this.searchGraph.connectDanglingRelations(this);
        this.addPostSearchPlanOperation(new InjectivityCheckOperation());
        this.printVariableMapping(logger);
    }

    boolean addSearchPlan(PatternCallSignature signature, SearchPlan plan) {
        return false;
    }

    MatchingFrame getInstance() {
        return null;
    }

    Collection<SearchPlan> getSearchPlansFor(SearchPlanKey key) {
        return this.searchPlanMapping.get(key);
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public ISearchGraph getSearchGraph() {
        return this.searchGraph;
    }

    public void addPreSearchPlanOperation(SearchPlanOperation operation) {
        this.preSearchPlanOperations.add(operation);
    }

    public void addPostSearchPlanOperation(SearchPlanOperation operation) {
        this.postSearchPlanOperations.add(operation);
    }

    public Integer getIndex(VariableID variable) {
        return this.variableMapping.get(variable);
    }

    public Set<VariableID> getVariableIDs(Integer index) {
        return this.inverseVariableMapping.get(index);
    }

    private void addToInverseMapping(VariableID variable, Integer index) {
        Set<VariableID> idSet = this.inverseVariableMapping.get(index);
        if (idSet == null) {
            idSet = new HashSet<VariableID>();
            this.inverseVariableMapping.put(index, idSet);
        }
        idSet.add(variable);
    }

    public void setIndex(VariableID variable, Integer index) {
        this.variableMapping.put(variable, index);
        this.addToInverseMapping(variable, index);
    }

    public int addVariable(VariableID variable) {
        if (variable != null) {
            this.variableMapping.put(variable, this.frameSize);
            this.addToInverseMapping(variable, this.frameSize);
        }
        return this.frameSize++;
    }

    private void printVariableMapping(Logger logger) {
        for (VariableID id : this.variableMapping.keySet()) {
            logger.debug(String.valueOf(id.toString()) + " : " + this.variableMapping.get(id));
        }
        for (Integer key : this.inverseVariableMapping.keySet()) {
            for (VariableID id : this.inverseVariableMapping.get(key)) {
                logger.debug(key + " : " + id.toString());
            }
        }
        logger.debug("Injective frame size: \t" + this.injectivityFrameSize);
        logger.debug("Frame size: \t" + this.frameSize);
    }

    public boolean containsIndex(VariableID variable) {
        return this.variableMapping.containsKey(variable);
    }

    @Override
    public int compareTo(FlattenedPattern o) {
        if (this.isRecursionBased == o.isRecursionBased) {
            return 0;
        }
        return this.isRecursionBased ? 1 : -1;
    }

    public int getInjectivityFrameSize() {
        return this.injectivityFrameSize;
    }

    public ITermHandler getTermHandler() {
        return this.parent.getTermHandler();
    }

    public Collection<SearchPlanOperation> generateCoreSearchPlan(Boolean[] adornment, IModelManager manager) throws PatternMatcherRuntimeException {
        return this.searchGraph.generateSearchPlan(this, adornment, manager);
    }

    public List<SearchPlanOperation> generateSearchPlan(Boolean[] adornment, IModelManager manager) throws PatternMatcherRuntimeException {
        Collection<SearchPlanOperation> vec = this.searchGraph.generateSearchPlan(this, adornment, manager);
        ArrayList<SearchPlanOperation> finalSearchPlan = new ArrayList<SearchPlanOperation>();
        finalSearchPlan.addAll(this.preSearchPlanOperations);
        finalSearchPlan.addAll(vec);
        finalSearchPlan.addAll(this.postSearchPlanOperations);
        SearchPlanOperation[] operations = new SearchPlanOperation[finalSearchPlan.size()];
        operations = finalSearchPlan.toArray(operations);
        SearchPlan splan = new SearchPlan(operations);
        splan.printDebugInformation(this.parent.getLogger());
        this.searchGraph.initSearchGraph();
        return finalSearchPlan;
    }

    IQueueContentProvider buildSubtree(Map<String, RemoteGoal> rggRoots, MagicSet ms, List<SearchPlanOperation> searchPlan, int upperBound, SortedSet<Integer> preCallInterfaceVariables) throws PatternMatcherRuntimeException {
        TreeSet<Integer> localVariables = new TreeSet<Integer>();
        int i = upperBound;
        while (i >= 0 && !(searchPlan.get(i) instanceof PatternCallOperation)) {
            searchPlan.get(i).calculateSidewaysPassedVariables(preCallInterfaceVariables);
            searchPlan.get(i).calculateLocalVariables(localVariables);
            --i;
        }
        if (upperBound < 0) {
            return ms;
        }
        if (i < upperBound) {
            IQueueContentProvider left = this.buildSubtree(rggRoots, ms, searchPlan, i, preCallInterfaceVariables);
            Vector<SearchPlanOperation> operations = new Vector<SearchPlanOperation>(searchPlan.subList(i + 1, upperBound + 1));
            operations.add(new DummyOperation());
            SearchPlanOperation[] array = new SearchPlanOperation[operations.size()];
            array = operations.toArray(array);
            LocalGoal right = new LocalGoal(array);
            return new UnindexedRule(this, left, right);
        }
        if (i == upperBound) {
            PatternCallOperation pco = (PatternCallOperation)searchPlan.get(i);
            pco.calculateSidewaysPassedVariables(preCallInterfaceVariables);
            pco.calculateLocalVariables(localVariables);
            IQueueContentProvider left = this.buildSubtree(rggRoots, ms, searchPlan, i - 1, preCallInterfaceVariables);
            String id = RemoteGoal.generateID(pco.getPatternNode(), pco.getAdornment());
            if (rggRoots.containsKey(id)) {
                RemoteGoal right = rggRoots.get(id);
                return new IndexedRule(this, left, right, pco.getParameterMapping(), pco.getAdornment());
            }
            RemoteGoal right = pco.getPatternNode().buildRuleGoalGraph(pco.getAdornment(), rggRoots);
            return new IndexedRule(this, left, right, pco.getParameterMapping(), pco.getAdornment());
        }
        String[] context = new String[]{this.getParent().getPattern().getName()};
        throw new PatternMatcherRuntimeException("[INTERNAL ERROR] An error happened during the creation of the Rule GOal GRaph of the {1} pattern.", context, (AnnotatedElement)this.getParent().getPattern());
    }

    public AnnotatedElement getGTASMRepresentation(AbstractNode node) {
        return this.searchGraph.getGTASMRepresentation(node);
    }

    public Pair addInjectivityExclusionPair(int left, int right) {
        Pair p = left < right ? new Pair(left, right) : new Pair(right, left);
        this.injectivityExclusionSet.add(p);
        return p;
    }

    public void removeInjectivityExclusionPair(int left, int right) {
        Pair p = left < right ? new Pair(left, right) : new Pair(right, left);
        this.injectivityExclusionSet.remove(p);
    }

    public Pair addInjectivityInclusionPair(int left, int right) {
        Pair p = left < right ? new Pair(left, right) : new Pair(right, left);
        this.injectivityInclusionSet.add(p);
        return p;
    }

    public void removeInjectivityInclusionPair(int left, int right) {
        Pair p = left < right ? new Pair(left, right) : new Pair(right, left);
        this.injectivityInclusionSet.remove(p);
    }

    public boolean isIncludedInInjectivityCheck(int i, int j) {
        Pair p = i < j ? new Pair(i, j) : new Pair(j, i);
        return this.injectivityInclusionSet.contains(p);
    }

    public static class Pair {
        private Integer left;
        private Integer right;

        public Integer getLeft() {
            return this.left;
        }

        public Integer getRight() {
            return this.right;
        }

        Pair(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object other) {
            if (other != null && other instanceof Pair) {
                Pair o = (Pair)other;
                return this.left == o.left && this.right == o.right;
            }
            return false;
        }

        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }
    }
}

