/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.EdgeType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.EdgeConstraintCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class ConstantToConstantCheckOperation
extends EdgeConstraintCheckOperation {
    private IModelElement source;
    private IModelElement target;
    private SearchGraphEdge edge;

    public ConstantToConstantCheckOperation(IModelElement source, IModelElement target, SearchGraphEdge edge) {
        this.source = source;
        this.target = target;
        this.edge = edge;
    }

    protected boolean check(MatchingFrame frame) throws PatternMatcherRuntimeException {
        if (this.source == null) {
            String[] context = new String[]{this.edge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.edge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.target == null) {
            String[] context = new String[]{this.edge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.edge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF && !this.edge.isSource()) {
            return this.source.isInstanceOf(this.target);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF && this.edge.isSource()) {
            return this.target.isInstanceOf(this.source);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.SUPERTYPEOF && !this.edge.isSource()) {
            return this.target.isSubtypeOf(this.source);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.SUPERTYPEOF && this.edge.isSource()) {
            return this.source.isSubtypeOf(this.target);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.SOURCE && !this.edge.isSource()) {
            return this.target instanceof IRelation ? ((IRelation)this.target).getFrom().equals(this.source) : false;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.SOURCE && this.edge.isSource()) {
            return this.source instanceof IRelation ? ((IRelation)this.source).getFrom().equals(this.target) : false;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.TARGET && !this.edge.isSource()) {
            return this.target instanceof IRelation ? ((IRelation)this.target).getTo().equals(this.source) : false;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.TARGET && this.edge.isSource()) {
            return this.source instanceof IRelation ? ((IRelation)this.source).getTo().equals(this.target) : false;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.IN && !this.edge.isSource()) {
            return this.source.getNamespace().compareTo((Object)this.target) == 0;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.IN && this.edge.isSource()) {
            return this.target.getNamespace().compareTo((Object)this.source) == 0;
        }
        if (this.edge.getVPMEdgeType() == EdgeType.BELOW && !this.edge.isSource()) {
            return this.source.isBelowNamespace(this.target);
        }
        if (this.edge.getVPMEdgeType() == EdgeType.BELOW && this.edge.isSource()) {
            return this.target.isBelowNamespace(this.source);
        }
        String[] context = new String[]{this.edge.getVPMEdgeType().toString(), this.getClass().getSimpleName()};
        throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' type VPM edge related to the '{2}' element is not supported as a check operation.", context, this.edge.getTraceabilityElement().getRepresentativeEMFElement());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.source.getName() + " -- " + this.edge.getVPMEdgeType().name() + " -> " + this.target.getName();
    }

    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.edge.getTraceabilityElement().getRepresentativeEMFElement();
    }
}

