/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodegenRecordingCoordinator<PatternDescription> {
    static final String varPrefix = "var";
    static final String buildablePrefix = "buildable";
    static final String collectorPrefix = "production";
    public Long nextIdentifier;
    public PrintStream code;
    public String stubType;
    public String collectorType;
    public String buildableType;
    HashMap<PatternDescription, String> collectors;
    LinkedHashSet<PatternDescription> unbuilt;
    public IPatternMatcherContext<PatternDescription> targetContext;

    public CodegenRecordingCoordinator(IPatternMatcherContext<PatternDescription> targetContext, PrintStream code, String stubType, String collectorType, String buildableType) {
        this.targetContext = targetContext;
        this.code = code;
        this.nextIdentifier = 0L;
        this.stubType = stubType;
        this.collectorType = collectorType;
        this.buildableType = buildableType;
        this.collectors = new HashMap();
        this.unbuilt = new LinkedHashSet();
    }

    String newIdentifier(String prefix) {
        Long l = this.nextIdentifier;
        this.nextIdentifier = l + 1L;
        return String.valueOf(prefix) + "_" + l.toString();
    }

    String newVariableIdentifier() {
        return this.newIdentifier(varPrefix);
    }

    String newBuildableIdentifier() {
        return this.newIdentifier(buildablePrefix);
    }

    String newCollectorIdentifier() {
        return this.newIdentifier(collectorPrefix);
    }

    void emitLine(String indent, String line) {
        this.code.println(String.valueOf(indent) + line);
    }

    String allocateNewCollector(PatternDescription pattern) {
        if (this.collectors.containsKey(pattern)) {
            throw new UnsupportedOperationException("Duplicate production nodes unsupported in RETE code generation");
        }
        String prod = this.newCollectorIdentifier();
        this.collectors.put(pattern, prod);
        this.unbuilt.remove(pattern);
        return prod;
    }

    public void printMembers(String indent) {
        for (String collector : this.collectors.values()) {
            this.emitLine(indent, String.valueOf(this.collectorType) + " " + collector + ";");
        }
    }

    public boolean isComplete() {
        return this.unbuilt.isEmpty();
    }

    public PatternDescription nextUnbuilt() {
        return (PatternDescription)this.unbuilt.iterator().next();
    }
}

