/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index;

import java.util.Collection;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.DualInputNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.Indexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IterableIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistenceNode
extends DualInputNode {
    protected boolean negative;

    public ExistenceNode(ReteContainer reteContainer, IterableIndexer primarySlot, Indexer secondarySlot, boolean negative) {
        super(reteContainer, primarySlot, secondarySlot, null);
        this.negative = negative;
    }

    @Override
    public Tuple calibrate(Tuple primary, Tuple secondary) {
        return primary;
    }

    @Override
    public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change) {
        switch (side) {
            case PRIMARY: {
                if (!(this.retrieveOpposites(side, signature) != null ^ this.negative)) break;
                this.propagateUpdate(direction, updateElement);
                break;
            }
            case SECONDARY: {
                Collection<Tuple> opposites;
                if (!change || (opposites = this.retrieveOpposites(side, signature)) == null) break;
                for (Tuple opposite : opposites) {
                    this.propagateUpdate(this.negative ? direction.opposite() : direction, opposite);
                }
                break;
            }
        }
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        this.reteContainer.flushUpdates();
        for (Tuple signature : this.primarySlot.getSignatures()) {
            Collection<Tuple> primaries = this.primarySlot.get(signature);
            Collection<Tuple> opposites = this.secondarySlot.get(signature);
            if (!(opposites != null ^ this.negative)) continue;
            collector.addAll(primaries);
        }
    }
}

