/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index;

import java.util.Collection;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.DualInputNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.Indexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IterableIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OuterJoinNode
extends DualInputNode {
    final Tuple defaults;

    public OuterJoinNode(ReteContainer reteContainer, IterableIndexer primarySlot, Indexer secondarySlot, TupleMask complementerSecondaryMask, Tuple defaults) {
        super(reteContainer, primarySlot, secondarySlot, complementerSecondaryMask);
        this.defaults = defaults;
    }

    @Override
    public Tuple calibrate(Tuple primary, Tuple secondary) {
        return this.unify(primary, secondary);
    }

    @Override
    public void notifyUpdate(DualInputNode.Side side, Direction direction, Tuple updateElement, Tuple signature, boolean change) {
        Collection<Tuple> opposites = this.retrieveOpposites(side, signature);
        switch (side) {
            case PRIMARY: {
                if (opposites != null) {
                    for (Tuple opposite : opposites) {
                        this.propagateUpdate(direction, this.unify(updateElement, opposite));
                    }
                    break;
                }
                this.propagateUpdate(direction, this.unifyWithDefaults(updateElement));
                break;
            }
            case SECONDARY: {
                if (opposites == null) break;
                for (Tuple opposite : opposites) {
                    this.propagateUpdate(direction, this.unify(opposite, updateElement));
                    if (!change) continue;
                    this.propagateUpdate(direction.opposite(), this.unifyWithDefaults(opposite));
                }
                break;
            }
        }
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        this.reteContainer.flushUpdates();
        for (Tuple signature : this.primarySlot.getSignatures()) {
            Collection<Tuple> primaries = this.primarySlot.get(signature);
            Collection<Tuple> opposites = this.secondarySlot.get(signature);
            if (opposites != null) {
                for (Tuple ps : primaries) {
                    for (Tuple opposite : opposites) {
                        collector.add(this.unify(DualInputNode.Side.PRIMARY, ps, opposite));
                    }
                }
                continue;
            }
            for (Tuple ps : primaries) {
                collector.add(this.unifyWithDefaults(ps));
            }
        }
    }

    private Tuple unifyWithDefaults(Tuple ps) {
        return this.unify(ps, this.defaults);
    }
}

