/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.Indexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IndexerListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

public abstract class StandardIndexer
implements Indexer {
    protected ReteContainer reteContainer;
    protected long nodeId;
    protected Object tag;
    protected Supplier parent;
    protected List<IndexerListener> listeners;
    protected TupleMask mask;

    public StandardIndexer(ReteContainer reteContainer, TupleMask mask) {
        this.reteContainer = reteContainer;
        this.nodeId = reteContainer.registerNode(this);
        this.parent = null;
        this.mask = mask;
        this.listeners = new ArrayList<IndexerListener>();
    }

    protected void propagate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
        for (IndexerListener listener : this.listeners) {
            listener.notifyIndexerUpdate(direction, updateElement, signature, change);
        }
    }

    public TupleMask getMask() {
        return this.mask;
    }

    public Supplier getParent() {
        return this.parent;
    }

    public void attachListener(IndexerListener listener) {
        this.listeners.add(listener);
    }

    public void detachListener(IndexerListener listener) {
        this.listeners.remove(listener);
    }

    public ReteContainer getContainer() {
        return this.reteContainer;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public String toString() {
        if (this.tag != null) {
            return "[" + this.nodeId + "]" + this.getClass().getSimpleName() + "(" + this.parent + "/" + this.mask + ")" + " [[" + this.tag.toString() + "]]";
        }
        return "[" + this.nodeId + "]" + this.getClass().getSimpleName() + "(" + this.parent + "/" + this.mask + ")";
    }
}

