/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.Disconnectable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.IManipulationListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.IPredicateTraceListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReteBoundary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.IRetePatternBuilder;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.Indexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.RetePatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Library;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Network;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Production;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteEngine<PatternDescription> {
    protected Network reteNet;
    protected int reteThreads;
    protected ReteBoundary<PatternDescription> boundary;
    protected IPatternMatcherRuntimeContext<PatternDescription> context;
    protected Collection<Disconnectable> disconnectables;
    protected IManipulationListener manipulationListener;
    protected IPredicateTraceListener traceListener;
    protected Map<PatternDescription, RetePatternMatcher> matchers;
    protected IRetePatternBuilder<PatternDescription, Address<? extends Supplier>, Address<? extends Receiver>> builder;
    protected boolean parallelExecutionEnabled;
    protected BlockingQueue<Exception> caughtExceptions;

    public ReteEngine(IPatternMatcherRuntimeContext<PatternDescription> context, int reteThreads) {
        this.context = context;
        this.reteThreads = reteThreads;
        this.initEngine();
        this.builder = null;
    }

    void initEngine() {
        this.parallelExecutionEnabled = this.reteThreads > 0;
        this.disconnectables = new LinkedList<Disconnectable>();
        this.caughtExceptions = new LinkedBlockingQueue<Exception>();
        this.reteNet = new Network(this.reteThreads);
        this.boundary = new ReteBoundary(this);
        this.matchers = new HashMap<PatternDescription, RetePatternMatcher>();
        this.manipulationListener = this.context.subscribePatternMatcherForUpdates(this);
        this.traceListener = this.context.subscribePatternMatcherForTraceInfluences(this);
    }

    void deconstructEngine() {
        this.reteNet.kill();
        for (Disconnectable disc : this.disconnectables) {
            disc.disconnect();
        }
        this.matchers = null;
        this.disconnectables = null;
        this.reteNet = null;
        this.boundary = null;
        this.manipulationListener = null;
        this.traceListener = null;
    }

    public void killEngine() {
        this.deconstructEngine();
        this.builder = null;
    }

    public void reset() {
        this.deconstructEngine();
        this.initEngine();
        this.builder.refresh();
    }

    public synchronized RetePatternMatcher accessMatcher(PatternDescription gtPattern) throws RetePatternBuildException {
        RetePatternMatcher matcher = this.matchers.get(gtPattern);
        if (matcher == null) {
            this.context.modelReadLock();
            try {
                if (this.parallelExecutionEnabled) {
                    this.reteNet.getStructuralChangeLock().lock();
                }
                try {
                    Address<Production> prodNode = this.boundary.accessProduction(gtPattern);
                    matcher = new RetePatternMatcher(this, prodNode);
                    this.matchers.put(gtPattern, matcher);
                }
                finally {
                    if (this.parallelExecutionEnabled) {
                        this.reteNet.getStructuralChangeLock().unlock();
                    }
                }
            }
            finally {
                this.context.modelReadUnLock();
            }
        }
        return matcher;
    }

    synchronized Indexer accessProjection(Production production, TupleMask mask) {
        Library library = this.reteNet.getHeadContainer().getLibrary();
        Indexer result = library.peekProjectionIndexer(production, mask);
        if (result == null) {
            this.context.modelReadLock();
            try {
                if (this.parallelExecutionEnabled) {
                    this.reteNet.getStructuralChangeLock().lock();
                }
                try {
                    result = library.accessProjectionIndexerOnetime(production, mask);
                }
                finally {
                    if (this.parallelExecutionEnabled) {
                        this.reteNet.getStructuralChangeLock().unlock();
                    }
                }
            }
            finally {
                this.context.modelReadUnLock();
            }
        }
        return result;
    }

    public void settle() {
        this.reteNet.waitForReteTermination();
    }

    public void settle(Runnable action) {
        this.reteNet.waitForReteTermination(action);
    }

    public Network getReteNet() {
        return this.reteNet;
    }

    public ReteBoundary<PatternDescription> getBoundary() {
        return this.boundary;
    }

    public void setBuilder(IRetePatternBuilder<PatternDescription, Address<? extends Supplier>, Address<? extends Receiver>> builder) {
        this.builder = builder;
    }

    public IManipulationListener getManipulationListener() {
        return this.manipulationListener;
    }

    public IPredicateTraceListener geTraceListener() {
        return this.traceListener;
    }

    public void addDisconnectable(Disconnectable disc) {
        this.disconnectables.add(disc);
    }

    public boolean isParallelExecutionEnabled() {
        return this.parallelExecutionEnabled;
    }

    public IPatternMatcherRuntimeContext<PatternDescription> getContext() {
        return this.context;
    }

    public IRetePatternBuilder<PatternDescription, Address<? extends Supplier>, Address<? extends Receiver>> getBuilder() {
        return this.builder;
    }

    public void logEvaluatorException(Exception e) {
        try {
            this.caughtExceptions.put(e);
        }
        catch (InterruptedException interruptedException) {
            this.logEvaluatorException(e);
        }
    }

    public Exception getNextLoggedEvaluatorException() {
        return (Exception)this.caughtExceptions.poll();
    }
}

