/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IdentityIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.NullIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.SingleInputNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMemory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniquenessEnforcerNode
extends SingleInputNode {
    protected Collection<Supplier> parents = new ArrayList<Supplier>();
    protected TupleMemory memory = new TupleMemory();
    protected NullIndexer nullIndexer;
    protected IdentityIndexer identityIndexer;
    protected int tupleWidth;

    public UniquenessEnforcerNode(ReteContainer reteContainer, int tupleWidth) {
        super(reteContainer);
        this.tupleWidth = tupleWidth;
        reteContainer.registerClearable(this.memory);
        this.nullIndexer = new NullIndexer(reteContainer, tupleWidth, this.memory, this);
        reteContainer.getLibrary().registerSpecializedProjectionIndexer(this, this.nullIndexer);
        this.identityIndexer = new IdentityIndexer(reteContainer, tupleWidth, this.memory, this);
        reteContainer.getLibrary().registerSpecializedProjectionIndexer(this, this.identityIndexer);
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        boolean change;
        if (direction == Direction.INSERT) {
            change = this.memory.add(updateElement);
        } else {
            try {
                change = this.memory.remove(updateElement);
            }
            catch (NullPointerException ex) {
                change = false;
                System.err.println("UniquenessEnforcer has detected duplicate deletion of" + updateElement);
                ex.printStackTrace();
            }
        }
        if (change) {
            this.propagateUpdate(direction, updateElement);
            this.identityIndexer.propagate(direction, updateElement);
            boolean radical = direction == Direction.REVOKE && this.memory.isEmpty() || direction == Direction.INSERT && this.memory.size() == 1;
            this.nullIndexer.propagate(direction, updateElement, radical);
        }
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        collector.addAll(this.memory);
    }

    public NullIndexer getNullIndexer() {
        return this.nullIndexer;
    }

    public IdentityIndexer getIdentityIndexer() {
        return this.identityIndexer;
    }

    @Override
    public void appendParent(Supplier supplier) {
        this.parents.add(supplier);
    }

    @Override
    public void removeParent(Supplier supplier) {
        this.parents.remove(supplier);
    }
}

