/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkListChangedListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.MachineListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineManager
implements IFrameworkListChangedListener {
    private static EngineManager instance = new EngineManager();
    Map<IFramework, MachineListener> machineListeners = new WeakHashMap<IFramework, MachineListener>();

    public static EngineManager getInstance() {
        return instance;
    }

    public EngineManager() {
        FrameworkManager.getInstance().addFrameworkListChangedListener((IFrameworkListChangedListener)this);
    }

    public ReteEngine<GTPattern> getReteEngine(IFramework framework) {
        return this.getMachineListener(framework).getEngine();
    }

    public MachineListener getMachineListener(IFramework framework) {
        MachineListener l = this.machineListeners.get(framework);
        if (l == null) {
            l = new MachineListener(framework);
            this.machineListeners.put(framework, l);
        }
        return l;
    }

    public void frameworkAdded(IFramework f) {
    }

    public void frameworkRemoved(IFramework f) {
        MachineListener m = this.machineListeners.get(f);
        if (m != null) {
            m.kill();
        }
        this.machineListeners.remove(f);
    }
}

