/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.gtasm.patternmatcher.ExecutionMode;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.ReteMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.RetePatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteGTASMPatternMatcher
implements IPatternMatcher {
    RetePatternMatcher matcher;

    public ReteGTASMPatternMatcher(RetePatternMatcher matcher) {
        this.matcher = matcher;
    }

    public boolean match(Object[] inputMapping) {
        boolean[] fixed = new boolean[inputMapping.length];
        int i = 0;
        while (i < inputMapping.length) {
            fixed[i] = !ValueKind.UNDEF_LITERAL.equals(inputMapping[i]);
            ++i;
        }
        return this.matcher.count(inputMapping, fixed) != 0;
    }

    public IMatching match(Object[] inputMapping, PatternCallSignature[] signature) {
        boolean ignoreScope = this.isScopeIgnorable(signature);
        if (!ignoreScope) {
            Collection result = this.matchAll(inputMapping, signature, null);
            return ((ArrayList)result).isEmpty() ? null : (IMatching)((ArrayList)result).iterator().next();
        }
        boolean[] fixed = new boolean[inputMapping.length];
        int i = 0;
        while (i < inputMapping.length) {
            fixed[i] = signature[i].getParameterMode() == ParameterMode.INPUT;
            ++i;
        }
        Tuple match = this.matcher.matchOne(inputMapping, fixed);
        return match == null ? null : new ReteMatching(match, this.matcher.getPosMapping());
    }

    public ArrayList<IMatching> matchAll(Object[] inputMapping, PatternCallSignature[] signature, Integer[] quantificationOrder) {
        boolean[] fixed = new boolean[inputMapping.length];
        boolean[] quantified = new boolean[inputMapping.length];
        boolean hasExistential = false;
        boolean hasUniversal = false;
        int i = 0;
        while (i < inputMapping.length) {
            fixed[i] = signature[i].getParameterMode() == ParameterMode.INPUT;
            boolean bl = quantified[i] = signature[i].getParameterMode() == ParameterMode.OUTPUT && signature[i].getExecutionMode() == ExecutionMode.MULTIPLE_RESULTS;
            if (!fixed[i]) {
                hasUniversal = hasUniversal || quantified[i];
                hasExistential = hasExistential || !quantified[i];
            }
            ++i;
        }
        boolean ignoreScope = this.isScopeIgnorable(signature);
        if (!hasUniversal && ignoreScope) {
            Tuple match = this.matcher.matchOne(inputMapping, fixed);
            return match == null ? new ArrayList<IMatching>() : new ArrayList<ReteMatching>(Collections.singleton(new ReteMatching(match, this.matcher.getPosMapping())));
        }
        ArrayList unscopedMatches = this.matcher.matchAll(inputMapping, fixed);
        if (unscopedMatches == null) {
            return new ArrayList<IMatching>();
        }
        ArrayList<IMatching> matchings = new ArrayList<IMatching>(unscopedMatches.size());
        TupleMask quantifiedMask = null;
        LinkedHashSet<Tuple> quantifiedProjections = null;
        if (hasExistential) {
            quantifiedMask = new TupleMask(quantified);
            quantifiedProjections = new LinkedHashSet<Tuple>();
        }
        for (Tuple ps : unscopedMatches) {
            Tuple quantifiedPart = null;
            if (hasExistential && quantifiedProjections.contains(quantifiedPart = quantifiedMask.transform(ps))) continue;
            boolean ok = true;
            if (!ignoreScope) {
                int k = 0;
                while (k < ps.getSize() && ok) {
                    if (signature[k].getParameterMode() != ParameterMode.INPUT) {
                        IEntity scopeParent = (IEntity)signature[k].getParameterScope().getParent();
                        Integer containmentMode = signature[k].getParameterScope().getContainmentMode();
                        ok = containmentMode == Scope.BELOW ? ok && ((IModelElement)ps.get(k)).isBelowNamespace((IModelElement)scopeParent) : ok && scopeParent.equals(((IModelElement)ps.get(k)).getNamespace());
                    }
                    ++k;
                }
            }
            if (!ok) continue;
            if (hasExistential) {
                quantifiedProjections.add(quantifiedPart);
            }
            matchings.add(new ReteMatching(ps, this.matcher.getPosMapping()));
        }
        return matchings;
    }

    public IMatching matchRandomly(Object[] inputMapping, PatternCallSignature[] signature) {
        Collection allMatches = this.matchAll(inputMapping, signature, null);
        if (allMatches == null || ((ArrayList)allMatches).isEmpty()) {
            return null;
        }
        return (IMatching)((ArrayList)allMatches).get((int)(Math.random() * (double)((ArrayList)allMatches).size()));
    }

    boolean isScopeIgnorable(PatternCallSignature[] signature) {
        PatternCallSignature[] patternCallSignatureArray = signature;
        int n = signature.length;
        int n2 = 0;
        while (n2 < n) {
            Scope scope;
            PatternCallSignature sig = patternCallSignatureArray[n2];
            if (sig.getParameterMode() == ParameterMode.OUTPUT && ((scope = sig.getParameterScope()).getContainmentMode() != Scope.BELOW || scope.getParent() != Scope.DEFAULT_PARENT)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Map<Integer, Scope> buildAdditionalScopeMap(PatternCallSignature[] signatures) {
        HashMap<Integer, Scope> scopeMap = new HashMap<Integer, Scope>();
        int i = 0;
        while (i < signatures.length) {
            PatternCallSignature signature = signatures[i];
            if (signature.getParameterMode().equals((Object)ParameterMode.OUTPUT) && !signature.getParameterScope().getParent().equals(Scope.DEFAULT_PARENT)) {
                scopeMap.put(i, signature.getParameterScope());
            }
            ++i;
        }
        return scopeMap;
    }
}

