/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.ASMFunctionContent;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.ASMFunctionContentChangeListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.Disconnectable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.IPredicateTraceListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.PredicateEvaluatorNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReteBoundary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ASMFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMFunctionListener
implements ASMFunctionContentChangeListener,
IPredicateTraceListener {
    protected Map<Tuple, Set<PredicateEvaluatorNode>> asmSensitiveTerms;
    protected ReteEngine<?> engine;
    protected ReteBoundary<?> boundary;

    public ASMFunctionListener(ReteEngine<?> engine) {
        this.engine = engine;
        this.boundary = engine.getBoundary();
        this.asmSensitiveTerms = new HashMap<Tuple, Set<PredicateEvaluatorNode>>();
        ASMFunctionContent.getInstance().addListener(null, (ASMFunctionContentChangeListener)this);
        engine.addDisconnectable((Disconnectable)this);
    }

    public void disconnect() {
        this.asmSensitiveTerms.clear();
        ASMFunctionContent.getInstance().removeListener(null, (ASMFunctionContentChangeListener)this);
    }

    public synchronized void registerSensitiveTrace(Tuple trace, PredicateEvaluatorNode node) {
        Set<PredicateEvaluatorNode> nodes = this.asmSensitiveTerms.get(trace);
        if (nodes == null) {
            nodes = new HashSet<PredicateEvaluatorNode>();
            this.asmSensitiveTerms.put(trace, nodes);
        }
        nodes.add(node);
    }

    public synchronized void unregisterSensitiveTrace(Tuple trace, PredicateEvaluatorNode node) {
        Set<PredicateEvaluatorNode> nodes = this.asmSensitiveTerms.get(trace);
        nodes.remove(node);
        if (nodes.isEmpty()) {
            this.asmSensitiveTerms.remove(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(ASMFunction f, EList<Object> key, Object newValue) {
        Object[] traceElements = new Object[key.size() + 1];
        int k = 0;
        traceElements[k++] = f;
        for (Object o : key) {
            traceElements[k++] = o;
        }
        FlatTuple trace = new FlatTuple(traceElements);
        ASMFunctionListener aSMFunctionListener = this;
        synchronized (aSMFunctionListener) {
            Set<PredicateEvaluatorNode> nodes = this.asmSensitiveTerms.get(trace);
            if (nodes != null) {
                LinkedList<PredicateEvaluatorNode> nodesCopy = new LinkedList<PredicateEvaluatorNode>(nodes);
                for (PredicateEvaluatorNode node : nodesCopy) {
                    this.boundary.notifyEvaluator(node.getAsmFunctionTraceNotifier(), (Tuple)trace);
                }
            }
        }
    }
}

